import{_ as h,a as p,b as c}from"./chunks/upload_permissions.CrL4J5u2.js";import{_ as d,h as g,ak as o,O as t,z as s,L as r,g as k,j as e,x as i}from"./chunks/framework.B7a_7emw.js";const u="/assets/running_profiler.DldCryFn.png",E="/assets/test-gaps-execution.lePfDQyl.png",_=JSON.parse('{"title":"Coverage for Java","description":"","frontmatter":{"title":"Coverage for Java"},"headers":[],"relativePath":"howto/setting-up-profiler-tga/java/index.md","filePath":"howto/setting-up-profiler-tga/java/index.md"}'),m={name:"howto/setting-up-profiler-tga/java/index.md"};function f(y,a,v,b,T,w){const l=r("PluginTabsTab"),n=r("PluginTabs");return k(),g("div",null,[a[5]||(a[5]=o('<h1 id="setting-up-test-coverage-profiling-for-java" tabindex="-1">Setting Up Test Coverage Profiling for Java <a class="header-anchor" href="#setting-up-test-coverage-profiling-for-java" aria-label="Permalink to &quot;Setting Up Test Coverage Profiling for Java&quot;">​</a></h1><nav class="table-of-contents"><ul><li><a href="#using-jacoco">Using JaCoCo</a></li><li><a href="#using-the-teamscale-java-profiler">Using the Teamscale Java Profiler</a><ul><li><a href="#prerequisite-generate-git-properties">Prerequisite: Generate git.properties</a></li><li><a href="#set-up-a-profiler-configuration">Set Up a Profiler Configuration</a></li><li><a href="#attaching-the-teamscale-java-profiler-to-your-system-under-test">Attaching the Teamscale Java Profiler to Your System Under Test</a></li><li><a href="#uploading-coverage-via-the-teamscale-java-profiler">Uploading Coverage via the Teamscale Java Profiler</a></li><li><a href="#validating-coverage-recording">Validating Coverage Recording</a></li></ul></li></ul></nav><p>In order to use the <strong>Test Gap analysis</strong>, you need to record test coverage and upload it to Teamscale. To record test coverage for Java (or other JVM languages, such as Kotlin), we recommend you use either <a href="#using-jacoco">JaCoCo</a> or the <a href="#using-the-teamscale-java-profiler">Teamscale Java Profiler</a>. Our guidelines for this decision are:</p><ul><li>If you want to profile your unit tests or other automated tests that are run in your CI environment, use <strong>JaCoCo</strong>.</li><li>If you want to profile manual tests, use the <strong>Teamscale Java Profiler</strong>.</li><li>If you want to profile a long-running process and want to upload test coverage to Teamscale in regular intervals (e.g., when profiling a web application), use the <strong>Teamscale Java Profiler</strong>.</li></ul><div class="tip custom-block"><p class="custom-block-title">Checkout our tutorial</p><p>In our <a href="./../../../tutorial/setting-up-tga-java/">general Java TGA tutorial</a> we outline the steps needed to set up TGA for a concrete sample project.</p></div><h2 id="using-jacoco" tabindex="-1">Using JaCoCo <a class="header-anchor" href="#using-jacoco" aria-label="Permalink to &quot;Using JaCoCo&quot;">​</a></h2><p>In order to set up <a href="https://www.jacoco.org/jacoco/trunk/doc/index.html" target="_blank" rel="noreferrer">JaCoCo</a> for automated tests running in your CI environment, install and configure one of its build system plugins:</p><ul><li>the <a href="./../../../reference/integrations/gradle-plugin/">JaCoCo Gradle plugin</a></li><li>the <a href="./../../../reference/integrations/maven-plugin/">JaCoCo Maven plugin</a></li><li>the <a href="https://www.eclemma.org/jacoco/trunk/doc/ant.html" target="_blank" rel="noreferrer">JaCoCo Ant tasks</a></li></ul><p>These plugins will write XML files containing the coverage information to disk after your tests have finished. You can upload these files to Teamscale as described in <a href="./../../uploading-external-data/">the instructions for uploading external analysis data</a>.</p><h2 id="using-the-teamscale-java-profiler" tabindex="-1">Using the Teamscale Java Profiler <a class="header-anchor" href="#using-the-teamscale-java-profiler" aria-label="Permalink to &quot;Using the Teamscale Java Profiler&quot;">​</a></h2><p>The <a href="./../../../reference/coverage-profilers/teamscale-java-profiler/">Teamscale Java Profiler</a> is a JVM coverage profiler that builds on JaCoCo. It records coverage from a JVM process and uploads it to Teamscale at regular intervals. This simplifies profiling of tests in long-running environments, such as deployments running in an application server, as well as manual tests.</p><p>The following instructions are for setting up the agent on a server or local machine. If your application is instead running in Docker, please read <a href="./../../setting-up-profiler-tga/java-with-docker/">our Docker guide</a> instead.</p><h3 id="prerequisite-generate-git-properties" tabindex="-1">Prerequisite: Generate <code>git.properties</code> <a class="header-anchor" href="#prerequisite-generate-git-properties" aria-label="Permalink to &quot;Prerequisite: Generate `git.properties`&quot;">​</a></h3><p>To upload the coverage to the correct commit in Teamscale, add a <code>git.properties</code> file to your jar/war. Depending on your environment there are multiple options:</p>',14)),t(n,null,{default:s(()=>[t(l,{label:"Maven"},{default:s(()=>[...a[0]||(a[0]=[e("p",null,"Just add the following plugin to your build:",-1),e("div",{class:"language-xml vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"xml"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"build"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    <"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugins"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"		<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugin"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"groupId"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">io.github.git-commit-id</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"groupId"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"artifactId"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">git-commit-id-maven-plugin</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"artifactId"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"version"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">9.0.1</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"version"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"executions"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"				<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"execution"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"id"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">get-the-git-infos</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"id"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goals"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"						<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goal"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">revision</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goal"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"goals"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"					<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"phase"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">initialize</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"phase"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"				</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"execution"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"executions"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"configuration"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"				<"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"generateGitPropertiesFile"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">true</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"generateGitPropertiesFile"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"			</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"configuration"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"		</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugin"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    </"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"plugins"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"</"),e("span",{style:{"--shiki-light":"#22863A","--shiki-dark":"#85E89D"}},"build"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">")])])])],-1)])]),_:1}),t(l,{label:"Gradle"},{default:s(()=>[...a[1]||(a[1]=[e("p",null,[i("You can achieve this by applying the "),e("a",{href:"https://plugins.gradle.org/plugin/com.gorylenko.gradle-git-properties",target:"_blank",rel:"noreferrer"},"gradle-git-properties plugin"),i(", as shown in the following example:")],-1),e("div",{class:"language-groovy vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"groovy"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"plugins {")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    id "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"com.gorylenko.gradle-git-properties"'),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," version "),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"2.4.2"')]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1}),t(l,{label:"Other"},{default:s(()=>[...a[2]||(a[2]=[e("p",null,[i("In case you are not using Git with Maven or Gradle you can also generate the "),e("code",null,"git.properties"),i(" file in your build. This file needs to contain a "),e("code",null,"git.commit.id"),i(" property corresponding to the respective code revision the current application was built from:")],-1),e("div",{class:"language-properties vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"properties"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"git.commit.id"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=6f735064d5a125d35a546675ee61a5f4a0f840aa")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"# When you intend to upload to Artifactory also add the following")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"git.branch"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=master")]),i(`
`),e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"git.commit.time"),e("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"=1593781474000")])])])],-1),e("p",null,"The file needs to be packaged into the jar or war file of your application.",-1)])]),_:1})]),_:1}),a[6]||(a[6]=o('<p>Now build and deploy your application.</p><h3 id="set-up-a-profiler-configuration" tabindex="-1">Set Up a Profiler Configuration <a class="header-anchor" href="#set-up-a-profiler-configuration" aria-label="Permalink to &quot;Set Up a Profiler Configuration&quot;">​</a></h3><p>The profiler&#39;s configuration can be stored within Teamscale. This makes it easy to change and audit. To configure the profiler for your application, go to the <em>Project Configuration</em> &gt; <em>Coverage Profilers</em> view. Open the dropdown of the <em>New profiler configuration</em> button and click on <em>Create for a JVM (Java, Kotlin, ...) project</em>.</p><p><img src="'+h+'" alt="The Java Profiler Configuration Wizard" style="max-width:400px;" width="612" height="174" data-zoom="true"></p><p>You will be presented with a dialog that lets you generate a profiler configuration for a Teamscale project.</p><p><img src="'+p+`" alt="The Teamscale Java Profiler Configuration Wizard" width="1282" height="1168" data-zoom="true"></p><ul><li>Select the project that you want to collect coverage for.</li><li>Choose a configuration ID. This ID will be used when starting the profiler so that it knows which configuration to use.</li><li>Select a <a href="./../../../glossary/#partition"><em>partition</em></a>, which is a logical name that groups related coverage, e.g., the type of test that will be profiled (e.g., <em>Manual Test</em>, <em>Unit Test</em>, <em>Regression Test</em>).</li><li>Select all packages that should be profiled. Subpackages are included as well.</li></ul><div class="tip custom-block"><p class="custom-block-title">Selecting Appropriate Packages</p><p>Teamscale automatically suggests packages to profile. Please review them carefully.</p><p>Please ensure the packages you select are &quot;future-proof&quot;, i.e., they also match packages you might add in the future. This saves you time later, because you won&#39;t have to adjust the profiler configuration whenever you add new packages.</p><p>Make sure not to profile widespread packages that are also used by third-party software, e.g. <code>net.java</code> or <code>com</code>.</p></div><p>Finally, click <em>Save</em>.</p><p>The generated profiler configuration looks similar to the following:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">includes</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=*com.company.product.*</span><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">;*com.company.commons.*</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">teamscale-project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=my-application</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">teamscale-partition</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=Manual Tests</span></span></code></pre></div><p>Next, please go back to the <em>Project Configuration</em> &gt; <em>Coverage Profilers</em> overview. Click on the <i class="users icon"></i> button next to the profiler configuration that you just created and assign <code>Viewer</code> permissions to the technical user that the profiler uses to connect to Teamscale.</p><p>Next, please go to <em>Admin</em> &gt; <em>Users</em> and select the technical user whose credentials should be used for the coverage upload. Ensure that the user has the <code>Perform External Uploads</code> permission for the project. You can achieve this by assigning the pre-defined <code>Build</code> project role to the user.</p><p><img src="`+c+'" alt="Build user permission settings" width="2012" height="796" data-zoom="true"></p><p>Then generate an access key by clicking on <em>Generate New Access Key</em> and save it. We will need it in the next step.</p><h3 id="attaching-the-teamscale-java-profiler-to-your-system-under-test" tabindex="-1">Attaching the Teamscale Java Profiler to Your System Under Test <a class="header-anchor" href="#attaching-the-teamscale-java-profiler-to-your-system-under-test" aria-label="Permalink to &quot;Attaching the Teamscale Java Profiler to Your System Under Test&quot;">​</a></h3><div class="tip custom-block"><p class="custom-block-title">Docker or Kubernetes</p><p>Please follow <a href="./../java-with-docker/">our Docker how-to</a> if your application is running in a Docker container.</p></div><p>Download <a href="https://github.com/cqse/teamscale-jacoco-agent/releases" target="_blank" rel="noreferrer">the latest release of the Teamscale Java Profiler</a> and extract it. Run the installer via the following command and replace the Teamscale server URL, user and access token from the previous step.</p>',18)),t(n,null,{default:s(()=>[t(l,{label:"Linux"},{default:s(()=>[...a[3]||(a[3]=[e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"sudo"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," ./installer"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," install"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," https://your.teamscale.url"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," your-build-user-name"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," your-access-token")])])])],-1)])]),_:1}),t(l,{label:"Windows"},{default:s(()=>[...a[4]||(a[4]=[e("p",null,"Run the following as administrator:",-1),e("div",{class:"language-shell vp-adaptive-theme"},[e("button",{title:"Copy Code",class:"copy"}),e("span",{class:"lang"},"shell"),e("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[e("code",null,[e("span",{class:"line"},[e("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"./installer.bat"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," install"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," https://your.teamscale.url"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," your-build-user-name"),e("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," your-access-token")])])])],-1)])]),_:1})]),_:1}),a[7]||(a[7]=o(`<p>Now add the following environment variable to the start script of your System Under Test.</p><div class="language-shell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">shell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">TEAMSCALE_JAVA_PROFILER_CONFIG_ID</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">my-application-backend</span></span></code></pre></div><p>Make sure to replace <code>my-application-backend</code> with the configuration ID you have chosen in the previous step. If you are using an application server like WebSphere, JBoss, Wildfly etc. please have look at the <a href="./../../../reference/coverage-profilers/teamscale-java-profiler/advanced-setup/#installation-special-cases">specific instructions</a>.</p><div class="tip custom-block"><p class="custom-block-title">The Environment Variable is Important</p><p>The installer will set up the Teamscale Java Profiler so it can profile all JVM applications on your system. However, it will only instrument applications and upload their coverage if you apply the environment variable to it.</p></div><h4 id="manual-installation" tabindex="-1">Manual installation <a class="header-anchor" href="#manual-installation" aria-label="Permalink to &quot;Manual installation&quot;">​</a></h4><p>In case you cannot or do not want to use our installer, follow these steps.</p><p>Move the extracted Teamscale Java Profiler somewhere next to your deployed application. We will refer to this directory as <code>TEAMSCALE_JACOCO_AGENT_DIR</code> in the following.</p><p>Now create a <code>TEAMSCALE_JACOCO_AGENT_DIR/teamscale.properties</code> file with the following content and replace the Teamscale server URL, user and access token:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">url</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=https://your.teamscale.url</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">username</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=your-build-user-name</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">accesskey</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=your-access-token</span></span></code></pre></div><p>As a next step, add the Teamscale Java Profiler as an agent to your system under test, by adding the following JVM argument to the configuration of your deployment.</p><div class="language-shell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">shell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">-javaagent:TEAMSCALE_JACOCO_AGENT_DIR/lib/teamscale-jacoco-agent.jar</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">=config-id=my-application-backend</span></span></code></pre></div><p>Make sure to replace <code>TEAMSCALE_JACOCO_AGENT_DIR</code> and <code>my-application-backend</code> with the actual agent file path and the configuration ID you have chosen in the previous step.</p><div class="danger custom-block"><p class="custom-block-title">The Order of the Command-Line Arguments Matters</p><p>The <code>-javaagent</code> option <strong>must</strong> be specified <strong>before</strong> the <code>-jar</code> option!</p></div><p>If you are using an application server like WebSphere, JBoss, Wildfly etc. please have look at the <a href="./../../../reference/coverage-profilers/teamscale-java-profiler/advanced-setup/#installation-special-cases">specific instructions</a>.</p><h3 id="uploading-coverage-via-the-teamscale-java-profiler" tabindex="-1">Uploading Coverage via the Teamscale Java Profiler <a class="header-anchor" href="#uploading-coverage-via-the-teamscale-java-profiler" aria-label="Permalink to &quot;Uploading Coverage via the Teamscale Java Profiler&quot;">​</a></h3><p>Now start your system under test, as you normally do. In the <em>Project Configuration</em> &gt; <em>Coverage Profilers</em> view you should see an entry that shows that your application is running with the profiler attached to it.</p><p><img src="`+u+'" alt="Running Profilers" width="2016" height="372" data-zoom="true"></p><p>Now perform some actions in your application, such that some part of the functionality is executed. Then shut down the application. The agent automatically uploads the coverage to Teamscale. By default, the upload happens at an interval of 8 hours and on JVM shutdown. The interval is useful for long-running applications like web applications where coverage should be reported continuously without restarting the application. It can freely be adjusted to fit your needs, by adding, an e.g., an <code>interval=60</code> entry to the profiler configuration, to set the upload interval to 60 minutes. But be aware that intervals smaller than 2 hours might slow down your Teamscale instance, depending on the amount of coverage data generated.</p><p>For a detailed reference on all the configuration options of the Teamscale Java Profiler, please refer to <a href="./../../../reference/coverage-profilers/teamscale-java-profiler/#options">the agent&#39;s documentation</a>.</p><h3 id="validating-coverage-recording" tabindex="-1">Validating Coverage Recording <a class="header-anchor" href="#validating-coverage-recording" aria-label="Permalink to &quot;Validating Coverage Recording&quot;">​</a></h3><p>Open the <em>Test Gaps</em> perspective and select your project and the branch from which the deployed application has been built from. Also make sure the new coverage partition is selected in the coverage partition chooser. Next, click on the <em>Execution</em> cell of the <em>Summary</em> row. <img src="'+E+'" alt="The execution summary" width="2118" height="214" data-zoom="true"> A dialog opens and should show some green rectangles, which represent the covered methods.</p><div class="tip custom-block"><p class="custom-block-title">Troubleshooting Missing Test Coverage</p><p>In case you do not see test coverage in the treemap, e.g., no green rectangles, please check whether the agent&#39;s log files (<code>/tmp/teamscale-java-profiler-&lt;PID&gt;-&lt;random string&gt;/logs/</code>) contain any relevant warnings or errors. Please also check the points mentioned in the <a href="./../../../troubleshooting/#test-coverage-is-missing-in-teamscale">&quot;Test coverage does not show up in Teamscale&quot; Troubleshooting section</a>. In case you still do not receive proper coverage, you might want to turn on debug logging in the Teamscale Java Profiler and have a look at the log files. Please refer to <a href="./../../../reference/coverage-profilers/teamscale-java-profiler/">the profilers documentation</a> for more details.</p></div>',22))])}const P=d(m,[["render",f]]);export{_ as __pageData,P as default};
