import{_ as t,h as a,ak as s,g as i}from"./chunks/framework.B7a_7emw.js";const u=JSON.parse('{"title":"Teamscale Server Administration","description":"","frontmatter":{"title":"Teamscale Server Administration"},"headers":[],"relativePath":"reference/administration-ts-installation/index.md","filePath":"reference/administration-ts-installation/index.md"}'),o={name:"reference/administration-ts-installation/index.md"};function n(r,e,l,d,c,h){return i(),a("div",null,[...e[0]||(e[0]=[s(`<h1 id="administration-of-a-teamscale-installation" tabindex="-1">Administration of a Teamscale Installation <a class="header-anchor" href="#administration-of-a-teamscale-installation" aria-label="Permalink to &quot;Administration of a Teamscale Installation&quot;">​</a></h1><p>This article gives a detailed reference of the configuration options of a Teamscale installation. It assumes that the <a href="./../../getting-started/installing-teamscale/">basic installation of Teamscale</a> is <strong>completed</strong> and Teamscale can be accessed via the web interface.</p><nav class="table-of-contents"><ul><li><a href="#configuring-teamscale">Configuring Teamscale</a><ul><li><a href="#primary-settings-–-teamscale-properties">Primary Settings – teamscale.properties</a></li><li><a href="#jvm-settings-–-jvm-properties">JVM Settings – jvm.properties</a></li><li><a href="#license-–-teamscale-license">License – teamscale.license</a></li><li><a href="#logging-–-log4j2-yaml">Logging – log4j2.yaml</a></li><li><a href="#encryption-–-teamscale-key">Encryption – teamscale.key</a></li><li><a href="#global-server-options-–-admin-settings-json">Global Server Options – admin-settings.json</a></li><li><a href="#stylesheet-–-custom-css">Stylesheet – custom.css</a></li></ul></li><li><a href="#separate-working-data-from-installation-files">Separate Working Data from Installation Files</a></li><li><a href="#usage-data-reporting-optional">Usage Data Reporting (optional)</a></li><li><a href="#configuring-session-timeout">Configuring Session Timeout</a></li><li><a href="#configuring-cors-settings">Configuring CORS Settings</a></li><li><a href="#configuring-connections-to-external-systems">Configuring Connections to External Systems</a></li><li><a href="#performance-considerations">Performance Considerations</a><ul><li><a href="#cpus-and-ram">CPUs and RAM</a></li><li><a href="#disk-performance">Disk Performance</a></li><li><a href="#storage-string-abbreviation-caching">Storage String Abbreviation Caching</a></li></ul></li><li><a href="#instance-comparison">Instance Comparison</a><ul><li><a href="#global-data">Global Data</a></li><li><a href="#projects">Projects</a></li></ul></li></ul></nav><h2 id="configuring-teamscale" tabindex="-1">Configuring Teamscale <a class="header-anchor" href="#configuring-teamscale" aria-label="Permalink to &quot;Configuring Teamscale&quot;">​</a></h2><p>The Teamscale installation can be adjusted to the host environment with configuration files, environment variables or JVM arguments.</p><p>Most configuration files are already shipped with the Teamscale installation in the <code>config</code> directory. If not explicitly specified, this is the only location for loading configuration files. Otherwise, configuration files are always loaded in the following order by Teamscale:</p><ul><li><p><strong>Dedicated Configuration Directory:</strong> If the environment variable <code>TEAMSCALE_CONFIG</code> is set, the folder which the variable points to is the primary location for loading configuration files. The default installation does not specify this variable.</p></li><li><p><strong>Process Working Directory:</strong> A folder named <code>config</code> within the working directory of the Teamscale Java process. The process working directory is the directory Teamscale is started from and equals the installation directory if not configured differently. See <a href="#separate-working-data-from-installation-files">Separate Working Data from Installation Files</a> for more information.</p></li><li><p><strong>Installation Directory:</strong> A folder named <code>config</code> within the installation directory. The installation directory is determined by the environment variable <code>TEAMSCALE_HOME</code>. This variable is set by startup scripts.</p></li></ul><p>This yields the following resolution order: <code>$TEAMSCALE_CONFIG/config.file</code>, <code>$PWD/config/config.file</code>, <code>$TEAMSCALE_HOME/config/config.file</code>. As soon a configuration file is found, other directories are no longer scanned.</p><h3 id="primary-settings-–-teamscale-properties" tabindex="-1">Primary Settings – teamscale.properties <a class="header-anchor" href="#primary-settings-–-teamscale-properties" aria-label="Permalink to &quot;Primary Settings – teamscale.properties&quot;">​</a></h3><p>The <code>teamscale.properties</code> file contains the most central configuration options for running Teamscale, e.g., specifying the amount of workers or where data is stored.</p><p>The file can be provided in any of the configuration directories. Loading of a specific config file can be forced with startup argument <code>-c /path/to/config.properties</code>. In addition properties can be provided with the environment variable <code>TS_PROPERTIES</code> and overwrite those in the configuration file.</p><p>The table below shows the options available in the <code>teamscale.properties</code> file.</p><table tabindex="0"><thead><tr><th>Option</th><th>Default</th><th>Description</th></tr></thead><tbody><tr><td><code>server.port</code></td><td><code>8080</code></td><td>HTTP server port</td></tr><tr><td><code>server.urlprefix</code></td><td></td><td>Prefix of URLs</td></tr><tr><td><code>server.bind-hostname</code></td><td></td><td>Bind address of the HTTP server</td></tr><tr><td><code>database.directory</code></td><td><code>storage</code></td><td>Database directory where all data is stored, relative to the process working directory.</td></tr><tr><td><code>database.type</code></td><td><code>leveldb</code></td><td>This is an expert setting and should not be changed. <br><small>Valid options are: <code>leveldb</code>, <code>rocksdb</code> and <code>xodus</code></small></td></tr><tr><td><code>database.cache-size</code></td><td><code>512</code></td><td>The cache size used by the database in MB</td></tr><tr><td><code>engine.workers</code></td><td><code>2</code></td><td>The number of concurrent analysis worker jobs. <br><small>See <a href="#configuring-workers">Configuring Workers</a> for details.</small></td></tr><tr><td><code>servicelog.loglevel</code></td><td><code>WARN</code></td><td>Log level for logging service calls - one of <code>OFF</code>, <code>INFO</code>, <code>WARN</code>, <code>ERROR</code></td></tr><tr><td><code>servicelog.logip</code></td><td><code>false</code></td><td>Whether to log the ip address of service calls</td></tr><tr><td><code>servicelog.loguser</code></td><td><code>false</code></td><td>Whether to log the user of service calls</td></tr><tr><td><code>https.port</code></td><td></td><td>Port to be used for HTTPS. <br><small>If this option is not set, HTTPS is disabled. See <a href="./../../howto/configuring-https/">this guide</a> to enable HTTPS.</small></td></tr><tr><td><code>https.keystore-path</code></td><td></td><td>The absolute path to the Java keystore containing the certificate and private key</td></tr><tr><td><code>https.keystore-password</code></td><td></td><td>The password for the keystore</td></tr><tr><td><code>https.certificate-alias</code></td><td></td><td>The alias of the certificate and private key in the keystore</td></tr><tr><td><code>custom-checks.dir</code></td><td><code>custom-checks</code></td><td>The directory where custom check JARs can be deployed. <br><small>A relative path will be resolved relative to the process working directory first and then, if not found there, relative to the installation directory.</small></td></tr></tbody></table><div class="warning custom-block"><p class="custom-block-title">RocksDB</p><p>To operate RocksDB on a Windows environment, please be aware that you also need to install the <a href="https://www.microsoft.com/en-us/download/details.aspx?id=48145" target="_blank" rel="noreferrer">Visual C++ Redistributable for Visual Studio 2015</a>.</p></div><h4 id="configuring-the-webserver" tabindex="-1">Configuring the Webserver <a class="header-anchor" href="#configuring-the-webserver" aria-label="Permalink to &quot;Configuring the Webserver&quot;">​</a></h4><p>In the default configuration, Teamscale starts a web server on your machine, using port <code>8080</code>, accessible via <a href="http://localhost:8080" target="_blank" rel="noreferrer"><code>http://localhost:8080</code></a>.</p><p>This web server will be also available from other machines in your network. If you do not want this, remove the comment before the line <code>server.bind-hostname=localhost</code> in the file <code>teamscale.properties</code>.</p><h4 id="configuring-workers" tabindex="-1">Configuring Workers <a class="header-anchor" href="#configuring-workers" aria-label="Permalink to &quot;Configuring Workers&quot;">​</a></h4><p>When working with multiple projects, <code>engine.workers</code> can be used to parallelize analyses.</p><ul><li>Increasing this value requires the <a href="#jvm-memory">JVM memory settings</a> to be adapted as well.</li><li>Allocate <strong>about 2GB per worker</strong>. For best performance use as many workers as cpu cores are available.</li><li>On larger instances, use one less worker so one core remains free for handling service requests during high-load situations.</li></ul><h3 id="jvm-settings-–-jvm-properties" tabindex="-1">JVM Settings – jvm.properties <a class="header-anchor" href="#jvm-settings-–-jvm-properties" aria-label="Permalink to &quot;JVM Settings – jvm.properties&quot;">​</a></h3><p>The config file <code>jvm.properties</code> contains environment variables that are loaded before the JVM starts.</p><div class="warning custom-block"><p class="custom-block-title">File format</p><p>Please be aware that this file is no regular shell or batch script. Multiline variables with <code>\\</code> escaping and environment variable expansion will not work.</p></div><p>Alternatively, one can specify environment variables directly on system or service level, e.g. <code>teamscale-service.xml</code>, <code>docker-compose.yml</code>, <code>teamscale.service</code>.</p><h4 id="jvm-memory" tabindex="-1">JVM Memory <a class="header-anchor" href="#jvm-memory" aria-label="Permalink to &quot;JVM Memory&quot;">​</a></h4><p>By default, the Teamscale start script will launch a JVM with a maximum Java heap size of 4GB. You can change this by adjusting <code>JVM_MEMORY</code> in <code>jvm.properties</code>.</p><p>Example: <code>JVM_MEMORY=8G</code> for a maximum heap size of 8 GB.</p><p>Alternatively, you can set the environment variable <code>TEAMSCALE_MEMORY</code> which takes precedence over the value specified in <code>jvm.properties</code></p><div class="tip custom-block"><p class="custom-block-title">Dealing with Memory Problems</p><p>If Teamscale runs into memory-related problems , please refer to this <a href="./../../troubleshooting/#teamscale-runs-into-memory-related-problems">troubleshooting section</a>.</p></div><h4 id="jvm-temporary-directory" tabindex="-1">JVM temporary directory <a class="header-anchor" href="#jvm-temporary-directory" aria-label="Permalink to &quot;JVM temporary directory&quot;">​</a></h4><p>The JVM uses the temporary directory of the executing user to store temporary files, e.g. <code>/tmp</code>, <code>C:\\Users\\&lt;username&gt;\\AppData\\Local\\Temp</code>. This can be changed by setting the environment variable <code>TEAMSCALE_TEMP</code>. Relative paths are supported and the directory is created if not existing.</p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>If you are running multiple Teamscale instances on the same server, it is recommended to specify separate temporary directories.</p></div><h4 id="jvm-arguments" tabindex="-1">JVM Arguments <a class="header-anchor" href="#jvm-arguments" aria-label="Permalink to &quot;JVM Arguments&quot;">​</a></h4><p>Additional flags (e.g, <code>-Dmy.flag=value</code>) that should be passed to the JVM can be specified using the <code>JVM_EXTRA_ARGS</code> variable. In addition, you can specify flags using the environment variables <code>JAVA_OPTS</code>, <code>TEAMSCALE_OPTS</code> and <code>TEAMSCALE_VM_ARGS</code>.</p><p>The JVM is always started with a predefined set of flags, e.g. <code>-Djava.awt.headless=true</code>. These flags can be overridden by specifying these again in, e.g. <code>JVM_EXTRA_ARGS</code>.</p><p>The order of arguments passed to the JVM is:</p><ul><li>Any default JVM arguments</li><li><code>JAVA_OPTS</code></li><li>Memory and temporary directory</li><li><code>TEAMSCALE_OPTS</code></li><li><code>TEAMSCALE_VM_ARGS</code></li><li><code>JVM_EXTRA_ARGS</code></li></ul><h3 id="license-–-teamscale-license" tabindex="-1">License – teamscale.license <a class="header-anchor" href="#license-–-teamscale-license" aria-label="Permalink to &quot;License – teamscale.license&quot;">​</a></h3><p>Teamscale needs a valid license to run. Teamscale automatically searches several locations for a valid Teamscale license (in this order):</p><ol><li>The content of the environment variable <code>TS_LICENSE</code>. The following example shows how to copy the content of a license file into the environment variable when starting Teamscale with the shell script.</li></ol><div class="language-shell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">shell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">TS_LICENSE</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$(</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">cat</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> ~/custom_folder/teamscale.license</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">)</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">export</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> TS_LICENSE</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">./teamscale.sh</span></span></code></pre></div><ol start="2"><li><p>A file named <code>teamscale.license</code> in any of the <a href="#configuring-teamscale">configuration directories</a></p></li><li><p>A file named <code>teamscale.license</code> in the home directory of the user running Teamscale</p></li></ol><p>You need to ensure that a valid license exists in one of these locations before starting Teamscale.</p><h3 id="logging-–-log4j2-yaml" tabindex="-1">Logging – log4j2.yaml <a class="header-anchor" href="#logging-–-log4j2-yaml" aria-label="Permalink to &quot;Logging – log4j2.yaml&quot;">​</a></h3><p>Teamscale writes a log-file named <code>logs/teamscale.log</code> in the process working directory.</p><p>To configure Teamscale&#39;s logging settings, you can do so in the file <code>log4j2.yaml</code> in one of the configuration directories. This is a Log4j 2 configuration file in the YAML format, which you can adjust according to the guidelines available at <a href="https://logging.apache.org/log4j/2.x/manual/configuration.html" target="_blank" rel="noreferrer">the official documentation page</a>. If you need to override the file location for some reason, you can set the Java system property <code>log4j.configurationFile</code> to point to the desired path. Alternatively, the environment variable <code>TS_LOGGING_CONF</code> may hold the content of a properties file as <a href="https://logging.apache.org/log4j/2.x/manual/configuration.html#Properties" target="_blank" rel="noreferrer">documented here</a>.</p><h3 id="encryption-–-teamscale-key" tabindex="-1">Encryption – teamscale.key <a class="header-anchor" href="#encryption-–-teamscale-key" aria-label="Permalink to &quot;Encryption – teamscale.key&quot;">​</a></h3><p>Teamscale encrypts all tables in the storage system that might contain sensitive information, such as passwords to your SVN server. The encryption algorithm used is AES-256. By default, Teamscale uses a default key that is hard-coded. To further improve security, you can provide your own key. For this, write your key or passphrase into the file <code>teamscale.key</code> in one of the <code>config</code> directories. Teamscale then uses the content of this file for initializing the key that is used to protect your data. The file should be protected using the usual file-system permissions.</p><p>If an own key is provided as described, Teamscale will use it for encrypting every backup. The benefit of this method is that nobody without your key file can read the encrypted parts of the backup. On the flip-side, you can not import this backup into an instance that does not know the secret key of the instance. To import into an instance that uses a different encryption key, you must provide the key as <em>alternative</em> decryption key. For this, place the key into the <code>config</code> directory using any file name with the extension <code>.key</code>. When reading a backup, Teamscale will automatically find the correct key to use.</p><h3 id="global-server-options-–-admin-settings-json" tabindex="-1">Global Server Options – admin-settings.json <a class="header-anchor" href="#global-server-options-–-admin-settings-json" aria-label="Permalink to &quot;Global Server Options – admin-settings.json&quot;">​</a></h3><p>The file <code>admin-settings.json</code> allows to configure all values that are available in the <a href="./../admin-settings/"><em>Admin</em> &gt; <em>Settings</em></a> view. This configuration file can be used to set these values in a non-interactive way to simplify provisioning of the Teamscale installation. The file contains a single JSON object, where each entry corresponds to one option that is used instead of the value configured in the server. Options that are set in the configuration file are no longer shown in the settings UI. Additionally, the configuration file allows to give an array of option names using the <code>hidden</code> key, which also should not be shown in the settings UI. This is especially useful for options that support multiple instances.</p><p>The example below hides the TFS and Crowd authentication options (and hence essentially disallows their configuration). Additionally, the base URL is fixed and a LDAP server is configured. Note that the configured LDAP server will not show up in the settings UI, but the UI will allow to configure additional LDAP servers. To construct the content of the JSON file, you can use the download buttons in the settings UI.</p><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;hidden&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">    &quot;auth.tfs.server&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">    &quot;auth.crowd.server&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ],</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;baseurl&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;baseUrl&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;https://teamscale.acme.comm&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  },</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;auth.ldap.server/MainLdap&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;hostname&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;ldap.acme.eu&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;port&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">389</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;useSSL&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">false</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;baseDN&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;dc=acme,dc=com&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;groupsBaseDN&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;groupAttribute&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;cn&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;bindDN&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;cn=admin,dc=acme,dc=com&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;bindPassword&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;secret-password&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;loginAttribute&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;sAMAccountName&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;memberUid&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;member&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;firstNameAttribute&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;givenName&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;lastNameAttribute&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;sn&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;emailAttribute&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;mail&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;updateSchedule&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;0 0 * * *&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">    &quot;userServer&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><h3 id="stylesheet-–-custom-css" tabindex="-1">Stylesheet – custom.css <a class="header-anchor" href="#stylesheet-–-custom-css" aria-label="Permalink to &quot;Stylesheet – custom.css&quot;">​</a></h3><p>The Teamscale installation can be customized with a separate stylesheet by creating a file <code>custom.css</code> in one of the configuration directories with CSS rules.</p><h2 id="separate-working-data-from-installation-files" tabindex="-1">Separate Working Data from Installation Files <a class="header-anchor" href="#separate-working-data-from-installation-files" aria-label="Permalink to &quot;Separate Working Data from Installation Files&quot;">​</a></h2><p>The process working directory is used to resolve <a href="#configuring-teamscale">configuration files</a> and relative directories specified in configuration files, e.g., the directory for data storage, custom checks or log files. If not explicitly configured the process working directory of Teamscale is identical to the Teamscale installation directory.</p><p>For a simpler update process of Teamscale you may prefer separating files provided by the Teamscale installation from manually edited configuration files and data calculated during analysis. This way you can simply replace the whole installation directory on an update, which may reduce manual effort if Teamscale is installed as Windows or Linux service.</p><p>Changing the process working directory depends on the used way of installing Teamscale on the host environment:</p><ul><li><strong>Plain Docker:</strong> Specify <code>--workdir</code> or <code>-w</code> when starting the container. The provided path should be mapped to the host or a volume.</li><li><strong>Docker Compose:</strong> Specify the <code>working_dir</code> key for the Teamscale service in your <code>docker-compose.yml</code>. The provided path should be mapped to the host or a volume.</li><li><strong>Windows service:</strong> Specify <code>workingdirectory</code> in <code>teamscale-service.xml</code>.</li><li><strong>Linux systemd service:</strong> Specify <code>WorkingDirectory</code> in the <code>teamscale.service</code> unit file.</li><li><strong>Stock startup script:</strong> When using <code>teamscale.sh</code> or <code>teamscale.bat</code>, simply <code>cd</code> to the directory you want to be the process working directory and start Teamscale by specifying the path to the startup script, e.g., <code>/path/to/teamscale/installation/teamscale.sh</code>.</li></ul><div class="danger custom-block"><p class="custom-block-title">DANGER</p><p>Please be aware that changing the process working directory after initial analysis may cause already calculated data to no longer be available in Teamscale as the storage directory will most likely be resolved to another location. You can, however, simply copy the existing storage directory to the new process working directory location.</p></div><h2 id="usage-data-reporting-optional" tabindex="-1">Usage Data Reporting (optional) <a class="header-anchor" href="#usage-data-reporting-optional" aria-label="Permalink to &quot;Usage Data Reporting (optional)&quot;">​</a></h2><p>You can help us to improve Teamscale by activating <em>Usage Data Reporting</em> in the Admin settings. This option will regularly transfer information about the used features and statistics about errors to our servers. You can configure, which information you are willing to share and also see a preview of the shared information. The preview dialog also contains a link to a web form that allows a one-time usage data reporting by copying the displayed preview information there. Please note that the automatic reporting needs out-bound HTTPS connection to our own servers.</p><div class="tip custom-block"><p class="custom-block-title">Usage Reporting</p><p>Teamscale will only report generic information, but never sensitive information such as code or user data.</p></div><h2 id="configuring-session-timeout" tabindex="-1">Configuring Session Timeout <a class="header-anchor" href="#configuring-session-timeout" aria-label="Permalink to &quot;Configuring Session Timeout&quot;">​</a></h2><p>By default, a user that logs into Teamscale obtains a session that lasts 90 minutes (<code>session-idle-timeout</code>). If the user is active, the session gets extended 60 minutes (<code>session-expiration-update-time</code>) before the token expires. Sessions get extended up to a maximum session length of 8 hours (<code>session-timeout</code>). This allows users to stay logged in as long as they are active every day - even in case of time zone changes. The default values follow the OWASP recommendations, it is not recommended to change them. Still, if you prefer a different behavior, you can configure it with the following <a href="#jvm-arguments">JVM arguments</a>. The session timeout is configured in hours, the other values in minutes. The session expiration update time needs to be smaller than the idle timeout, otherwise the session never gets extended.</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>-Dcom.teamscale.session-timeout=8</span></span>
<span class="line"><span>-Dcom.teamscale.session-idle-timeout=90</span></span>
<span class="line"><span>-Dcom.teamscale.session-expiration-update-time=60</span></span></code></pre></div><h2 id="configuring-cors-settings" tabindex="-1">Configuring CORS Settings <a class="header-anchor" href="#configuring-cors-settings" aria-label="Permalink to &quot;Configuring CORS Settings&quot;">​</a></h2><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>Please note if Teamscale is running behind a reverse proxy (e.g. NGINX), these settings should be applied within the reverse proxy and not Teamscale. More information about running Teamscale behind a reverse proxy <a href="./../../howto/configuring-reverse-proxy/">can be found here</a>.</p></div><p><strong>Background:</strong> HTML5 Cross-Site Origin Resource Sharing (CORS) is a mechanism in the HTML5 standard that provides a means for browser and server to agree on the resources that may be loaded from domains outside of the web page. JavaScript, for instance, may request access to a specific dynamically generated URL. Among others, the following three HTTP headers allow this fine-grained approach to access control:</p><ul><li>Origin</li><li>Access-Control-Allow-Origin</li><li>Access-Control-Allow-Credentials</li></ul><p>The client browser sends the Origin-Header to indicate that the client would like to share resources with that (external) origin. The web server responds with the header Access-Control-Allow-Origin to indicate which domains may access the resources of the server, and may further grant permissions for specific options. If the request and the permissions match, the browser releases the request for processing, e.g. by JavaScript.</p><p>You can configure the CORS policy applied by Teamscale using the following system properties:</p><table tabindex="0"><thead><tr><th>Name</th><th>Default Value</th><th>Description</th></tr></thead><tbody><tr><td><code>com.teamscale.server.cors.allowed-origins</code></td><td><em>Empty</em></td><td>comma separated list of origins that are allowed to access the resources. Note that using wild cards can result in security problems for requests identifying hosts that do not exist. If an allowed origin contains one or more <code>*</code> characters (for example <code>http://*.domain.com</code>), then <code>*</code> characters are converted to <code>.*</code>, <code>.</code> characters are escaped to <code>\\.</code> and the resulting allowed origin interpreted as a regular expression. Allowed origins can therefore be more complex expressions such as <code>https?://*.domain.[a-z]{3}</code> that matches http or https, multiple subdomains and any 3 letter top-level domain (.com, .net, .org, etc.).</td></tr><tr><td><code>com.teamscale.server.cors.allowed-headers</code></td><td><code>X-Requested-With,Content-Type,Accept,Origin</code></td><td>comma separated list of HTTP headers that are allowed to be specified when accessing the resources. If the value is a single <code>*</code>, this means that any headers will be accepted.</td></tr><tr><td><code>com.teamscale.server.cors.allowed-methods</code></td><td><code>GET,POST,HEAD</code></td><td>comma separated list of HTTP methods that are allowed to be used when accessing the resources.</td></tr><tr><td><code>com.teamscale.server.cors.allow-credentials</code></td><td><code>true</code></td><td>a boolean indicating if the resource allows requests with credentials.</td></tr></tbody></table><p>As the default value for <code>com.teamscale.server.cors.allowed-origins</code> is empty, Teamscale will not allow any CORS and is thus secure by default. If you intend to include Teamscale in other websites (e.g. <a href="./../../howto/connecting-to-issue-trackers/jira/#teamscale-dashboards-as-a-jira-gadget">Jira Dashboards</a>, <a href="https://marketplace.visualstudio.com/items?itemName=CQSEGmbH.teamscale-azure-devops-plugin" target="_blank" rel="noreferrer">Azure DevOps Extension</a>) you have to configure the settings accordingly. Usually, you just have to adapt the allowed origins, e.g.:</p><ul><li>Azure DevOps: <code>-Dcom.teamscale.server.cors.allowed-origins=https://dev.azure.com,https://&lt;your-domain&gt;.visualstudio.com</code></li><li>Jira Cloud: <code>-Dcom.teamscale.server.cors.allowed-origins=https://&lt;your-domain&gt;.atlassian.net</code></li></ul><h2 id="configuring-connections-to-external-systems" tabindex="-1">Configuring Connections to External Systems <a class="header-anchor" href="#configuring-connections-to-external-systems" aria-label="Permalink to &quot;Configuring Connections to External Systems&quot;">​</a></h2><p>If a request cannot be completed due to temporary connection problems, e.g. a timeout, Teamscale automatically retries the request. You can configure the behavior using the following system properties:</p><table tabindex="0"><thead><tr><th>Name</th><th>Default Value</th><th>Description</th></tr></thead><tbody><tr><td><code>com.teamscale.client.request-retry.attempts</code></td><td>3</td><td>The number of additional attempts Teamscale will perform to complete the request</td></tr><tr><td><code>com.teamscale.client.request-retry.delay-millis</code></td><td>1000</td><td>The time to wait between the initial request and the first retry. Each subsequent retry will be delayed twice as long as the one before (exponential backoff).</td></tr><tr><td><code>azure-devops.timeout-retry.attempts</code></td><td>5</td><td>Can be used to specify a different number of retries for Azure DevOps. If both <code>azure-devops.timeout-retry.attempts</code> and <code>com.teamscale.client.request-retry.attempts</code> are not configured, the default value of 5 is used.</td></tr><tr><td><code>azure-devops.timeout-retry.delay-millis</code></td><td>1000</td><td>Can be used to specify a different delay between retries for Azure DevOps.</td></tr></tbody></table><h2 id="performance-considerations" tabindex="-1">Performance Considerations <a class="header-anchor" href="#performance-considerations" aria-label="Permalink to &quot;Performance Considerations&quot;">​</a></h2><p>If your Teamscale instance processes only a moderate amount of code, performance will not be an issue. However, the more projects and users you add to an instance, the more you will have to think about performance. While obviously more CPU cores and RAM will help in most cases, often the main bottleneck is I/O performance.</p><h3 id="cpus-and-ram" tabindex="-1">CPUs and RAM <a class="header-anchor" href="#cpus-and-ram" aria-label="Permalink to &quot;CPUs and RAM&quot;">​</a></h3><p>More CPU cores means that you can use more workers, which allows Teamscale to process more analysis steps in parallel. However, there is a limit to the amount of parallelization of a single project. So if you have only few huge projects, more workers will not necessarily help. You should never configure more workers than you have CPU cores. In case of many users or overall slow response times of the web UI, you even should configure less workers than CPU cores, to keep some spare resources for the service layer.</p><p>You should plan with a minimum of 2 GB RAM per worker. If you have few workers, add 2 GB RAM for the scheduler and the service layer. For larger instances, this extra RAM does not really matter. For complex code bases (e.g. ABAP with taint analysis, huge amount of cloning, etc.) you should add significantly more RAM per worker; for taint analysis in ABAP, we often have 5 GB per worker. Also remember that you can not use all the RAM of the machine for the Java VM, as the database itself needs some RAM for caching (outside of JVM) and the operating system needs RAM as well. As Teamscale can use RAM for caching of intermediate results at a lot of layers and stages, giving more RAM to the Java VM (in <code>jvm.properties</code>) will often help to improve performance.</p><h3 id="disk-performance" tabindex="-1">Disk Performance <a class="header-anchor" href="#disk-performance" aria-label="Permalink to &quot;Disk Performance&quot;">​</a></h3><p>Teamscale is very I/O sensitive, as it processes a lot of data. The most crucial factor is the number of random access read/write operations, that the disk can perform per second. We strongly recommend using a local SSD if possible. Never use a network drive, as usually the performance will be bad.</p><h4 id="measuring-i-o-performance" tabindex="-1">Measuring I/O Performance <a class="header-anchor" href="#measuring-i-o-performance" aria-label="Permalink to &quot;Measuring I/O Performance&quot;">​</a></h4><p>The number we use for comparing I/O performance is the number of <em>I/O operations per second</em> (IOPS). There are different tools for measuring this number and the exact values are only comparable between measurements with the same tool, as they depend on implementation details. We use the tool <code>fio</code> for measuring disk performance, which is available for <a href="https://support.binarylane.com.au/support/solutions/articles/1000055889-how-to-benchmark-disk-i-o" target="_blank" rel="noreferrer">Linux</a> and <a href="https://github.com/axboe/fio/releases" target="_blank" rel="noreferrer">Windows</a>. To determine the IOPS for your disk, run one of the two commands below matching your operating system.</p><p>Linux:</p><div class="language-shell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">shell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">fio</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --randrepeat=1</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --ioengine=libaio</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --direct=1</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --gtod_reduce=1</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --name=test</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --filename=test</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --bs=4k</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --iodepth=64</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --size=4G</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --readwrite=randrw</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --rwmixread=75</span></span></code></pre></div><p>Windows:</p><div class="language-shell vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">shell</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">fio</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --randrepeat=1</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --ioengine=windowsaio</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --direct=1</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --gtod_reduce=1</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --name=test</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --filename=test</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --bs=4k</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --iodepth=64</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --size=4G</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --readwrite=randrw</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --rwmixread=75</span></span></code></pre></div><p>The output will contain lines such as the following, which contain the IOPS for read and write operations (the first number in each line):</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>  read: IOPS=169k, BW=659MiB/s (691MB/s)(3070MiB/4658msec)</span></span></code></pre></div><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>  write: IOPS=56.4k, BW=220MiB/s (231MB/s)(1026MiB/4658msec); 0 zone resets</span></span></code></pre></div><p>To compare your numbers, use the following table:</p><table tabindex="0"><thead><tr><th>Server/Disk</th><th>Read IOPS</th><th>Write IOPS</th><th>Assessment</th></tr></thead><tbody><tr><td>Old magnetic disk</td><td>175</td><td>60</td><td>Too slow for Teamscale</td></tr><tr><td>AWS instance (m5.x2large with 500GB of GPIO EBS volume/SSD)</td><td>2256</td><td>752</td><td>Too slow for Teamscale</td></tr><tr><td>Customer cloud server (backed by network drive)</td><td>6950</td><td>2300</td><td>Too slow for Teamscale</td></tr><tr><td>AWS instance (m5d.x2large with 1000GB of provisioned IOPS SSD (50.000 IOPS configured))</td><td>14.2k</td><td>4.7k</td><td>Ok for medium sized instances</td></tr><tr><td>Customer server with fast local SSD</td><td>62k</td><td>21k</td><td>Ok for larger instances</td></tr><tr><td>Local SSD (Laptop from 2018)</td><td>99.4k</td><td>33.2k</td><td>Ok for larger instances</td></tr><tr><td>GCP instance with local SSD</td><td>105k</td><td>35.2k</td><td>Ok for larger instances</td></tr><tr><td>AWS instance (m5d.x2large using local NVMe SSD)</td><td>143k</td><td>47.7k</td><td>For very large instance</td></tr><tr><td>Local SSD (Laptop from 2021)</td><td>146k</td><td>48.9k</td><td>For very large instance</td></tr></tbody></table><h4 id="database-cache" tabindex="-1">Database Cache <a class="header-anchor" href="#database-cache" aria-label="Permalink to &quot;Database Cache&quot;">​</a></h4><p>The parameter <code>database.cache-size</code> in the <code>teamscale.properties</code> file controls the amount of memory used for database caching. The default value of 512 MB works well for small and medium instances. If you encounter performance issues, you should experiment with larger cache sizes. For huge instances, we have data cache sizes of 10 GB and more. Keep in mind, that the database cache is separate from the memory allocated for the Java VM, so make sure that both numbers (and some RAM for the operating system) fit well into the overall amount of RAM of the server.</p><div class="warning custom-block"><p class="custom-block-title">Too much database cache</p><p>Giving too much RAM to the database cache can even lead to reduced performance and stability of the instance in rare cases. Please make sure to test new settings in a non-productive environment first and be prepared to switch back to the original settings.</p></div><h4 id="database-sharding" tabindex="-1">Database Sharding <a class="header-anchor" href="#database-sharding" aria-label="Permalink to &quot;Database Sharding&quot;">​</a></h4><p>Database sharding describes the process of using multiple databases for one Teamscale instance. Note that this is an advanced topic and only needed for very large instances. The database layers used by Teamscale do scale well to an on-disk size of about 1 TB. Beyond this point, we often observe the database to slow down significantly. Additionally, the locking mechanisms in the database may cause delays and reduced parallelism when lots of analyses (workers) attempt to access the database at the same time.</p><p>To resolve this situation, you can configure Teamscale to distribute its data across multiple databases. Ideally, these databases would be split across multiple disks, but we see significant performance improvements even when the databases reside on the same disk. To activate sharding, the parameter <code>database.sharding</code> in <code>teamscale.properties</code> is used. To activate randomized sharding, where projects are mapped to shards in a random fashion, use the value <code>randomized:N</code>, where <code>N</code> should be replaced by the number of shards. The databases for shards are created in subdirectories of the storage directory provided by the <code>database.directory</code> parameter.</p><p>While randomized is helpful for initial tests, you usually want to control the mapping between projects and shards, e.g. to move large or heavily utilized projects to separate shards. For this, we use pattern based sharding, which is configured like in this example:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">database.sharding</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=pattern:GLOB:.*global.*:CLUSTER1:foo_.*:CLUSTER2:.*</span></span></code></pre></div><p>The first part (<code>pattern:</code>) is fixed and denotes pattern based sharding. This is followed by names of shards and mapping patterns. Each project (and the global data) is mapped to the first shard whose regular expression pattern matches any of the public ids of the project. To make sure that all projects can be mapped, the last shard should catch all projects by using <code>.*</code> as pattern.</p><div class="warning custom-block"><p class="custom-block-title">Database cache</p><p>Note that the database cache is applied <em>per shard</em>, so the amount of RAM used for caching is multiplied by the number of shards. Keep this in mind for the RAM allocation of Teamscale and the database caches.</p></div><div class="warning custom-block"><p class="custom-block-title">Redeployment needed</p><p>Changing the sharding configuration will invalidate the storage directory, so you have to start with an empty storage directory from scratch (or a backup). As you can not change this configuration on the fly, make sure to test the sharding settings thoroughly on a non-production instance.</p></div><div class="danger custom-block"><p class="custom-block-title">Too many shards</p><p>We have seen cases, where too many shards led to memory exhaustion and hence crashes of the instance and even the server.</p></div><h3 id="storage-string-abbreviation-caching" tabindex="-1">Storage String Abbreviation Caching <a class="header-anchor" href="#storage-string-abbreviation-caching" aria-label="Permalink to &quot;Storage String Abbreviation Caching&quot;">​</a></h3><p>Teamscale uses a global internal string abbreviator, which is used to compress keys and values for specific large database tables. Lookup results done in the global abbreviation table are kept in a cache, to improve lookup performance. The cache size in MB can be configured using a <a href="#jvm-arguments">JVM argument</a>:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>-Dcom.teamscale.persistence.string-abbreviation-cache-mb=XYZ</span></span></code></pre></div><p>The cache defaults to a size of <code>200</code>MB.</p><p>The Teamscale UI provides insight into the cache performance und utilization under <code>System -&gt; System Information</code> in the <code>Internal String Abbreviator Cache Statistics</code> section.</p><h2 id="instance-comparison" tabindex="-1">Instance Comparison <a class="header-anchor" href="#instance-comparison" aria-label="Permalink to &quot;Instance Comparison&quot;">​</a></h2><p>The goal of the instance comparison is to ensure that the data is still correct and complete. It is mostly used to compare the <a href="./../../howto/updating-teamscale/shadow-instance/">shadow instance</a> to the production instance during a <a href="./../../howto/updating-teamscale/feature-version/">feature version update</a>.</p><p>The instance comparison consists of two sections, the comparison of global and project-specific data between the live and shadow instances. The individual data points of the instance comparison are listed below. Potential causes for differences identified and suitable measures for eliminating and assessing these differences are presented. If you have any questions, please contact our <a href="mailto:support@teamscale.com">support team</a>.</p><h3 id="global-data" tabindex="-1">Global Data <a class="header-anchor" href="#global-data" aria-label="Permalink to &quot;Global Data&quot;">​</a></h3><ul><li>Users/Groups <ul><li>If users/groups are missing on the shadow instance, they can be added by performing a new backup sync</li><li>If there are too many users/groups on the shadow instance, e.g. the default admin user that is created when a new major version is deployed, these should be removed.</li></ul></li><li>Maintenance Worker Log Errors <ul><li>If there are errors that do not exist on the live instance, these should be investigated and an assessment on whether these errors are problematic should be conducted.</li></ul></li><li>Projects only in one instance <ul><li>If projects are missing in the shadow instance, these should be imported via a new backup.</li><li>If there are projects in the shadow instance that do not exist on the live instance, you should check whether the removal of the projects on the live instance is correct. If so, these projects should be removed from the shadow instance.</li></ul></li></ul><h3 id="projects" tabindex="-1">Projects <a class="header-anchor" href="#projects" aria-label="Permalink to &quot;Projects&quot;">​</a></h3><ul><li>File Contents <ul><li>Are there any differences in the files between the shadow and live instances (e.g. missing files on the shadow instance)? <ul><li>Are there differences in the project configuration that would explain the changes?</li><li>Take a look at the Teamscale <a href="./../../changelog/">changelog</a> and check whether there are any changes that explain the differences.</li><li>Another possible cause of missing files, for example, may be a different analysis progress between the instances</li></ul></li></ul></li><li>Findings <ul><li>New and disappeared findings should be checked</li><li>Differences should be explained by Teamscale&#39;s changelogs, for example through bug fixes, analysis improvements or updates to external tools</li></ul></li><li>Metrics <ul><li>Check whether differences in this column are due to changes in the File Contents or Findings columns.</li></ul></li><li>Parse Log Errors <ul><li>Indicates whether files cannot be parsed correctly. This could also explain differences in the Findings Churn column.</li></ul></li><li>Project Configuration <ul><li>Usually shows differences in the default values for checks.</li><li>Shows differences if the project configurations have changed after the backup was imported.</li></ul></li><li>Spec Items <ul><li>Are there requirement items that are missing in the shadow instance but are present on the live instance? <ul><li>It may be due to a relative start date in the requirements tracing connector configuration</li></ul></li></ul></li><li>Worker Log Errors <ul><li>Check that no new errors occur in the shadow instance that were not already present in the live instance.</li></ul></li></ul>`,121)])])}const m=t(o,[["render",n]]);export{u as __pageData,m as default};
