This check detects comments containing problem tags (e.g., `FIXME`, `HACK`).
What exactly is considered as a problem tag depends on the check configuration.

# Why is This a Problem?

Problem tags (e.g., `FIXME`, `HACK`) are an issue for two related but distinct reasons:

1. While they mark unresolved problems, they do so only in the code and are easily forgotten.
    As a consequence, very old problem tags may remain in the codebase for a long time.
    Those tend to be particularly confusing, because the comment is often no longer relevant, or because it is unclear what work needs to be done, especially if the original author is unknown or has left the development team.

3. They can also cause issues in the opposite direction:
    Relevant problems are hard to track if they are only mentioned as comment in the code but not reflected in the issue tracker.

## Exceptions

Comments with problem tags which also contain a reference to a ticket in an issue tracker can be useful to point out a known deficit of the current implementation.
If this should be an allowed use of problem tags, this check can be configured to ignore such comments.

# How Can I Resolve This?

Use problem tags only as short-term markers during your ongoing development task and remove them from the code before finishing the task.
In a branch-based development process, problem tags should be resolved before the code is merged into an upstream branch.
If the problem itself has not been resolved, create an issue in your issue tracker for it.

Depending on the configuration, it is also possible to fix the finding by adding a link to an issue which tracks resolution of the problem.

## Example (Before)

``` java
// FIXME breaks in case input is too large
```
``` java
// Hack to ensure all items are properly loaded.
```

## Example (After)

These only work if the check is configured accordingly:

``` java
// FIXME PROJ-1234 breaks in case input is too large
// (no finding, references a Jira issue)
```
``` java
// Hack to ensure all items are properly loaded. #1234
// (no finding, references a GitHub issue)
```
