/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.annotation;

import com.google.common.collect.Streams;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.atteo.classindex.ClassIndex;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ClassIndexUtils {
    public static List<Class<?>> getAnnotated(Class<? extends Annotation> annotation) {
        Iterable annotated = ClassIndex.getAnnotated(annotation);
        return Streams.stream((Iterable)annotated).filter(clazz -> clazz.isAnnotationPresent(annotation)).collect(Collectors.toList());
    }

    public static <T> Stream<Class<? extends T>> getConcreteSubclasses(Class<T> superClass) {
        return Streams.stream((Iterable)ClassIndex.getSubclasses(superClass)).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers()));
    }

    private ClassIndexUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

