/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization.legacy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.service.testimpact.prioritization.ETestSelectionReason;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.sourcecode.coverage.TestUniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;

public class PrioritizableTestPre80 {
    @JsonProperty(value="uniformPath")
    private String uniformPath;
    @JsonProperty(value="selectionReason")
    private ETestSelectionReason selectionReason;
    @JsonProperty(value="partition")
    private String partition;
    @JsonProperty(value="coveredMethodCount")
    private int numberOfCoveredMethods = 0;
    @JsonProperty(value="durationInMs")
    protected @Nullable Long durationInMs = null;
    @JsonProperty(value="currentScore")
    private double currentScore;
    @JsonProperty(value="additionallyCoveredMethodCount")
    private int numberOfAdditionallyCoveredMethods = 0;
    @JsonProperty(value="rank")
    private Integer rank;

    @JsonCreator
    public PrioritizableTestPre80() {
    }

    private PrioritizableTestPre80(PrioritizableTest prioritizableTest) {
        this.uniformPath = TestUniformPathUtils.convertCoverageUnitPathToTestName(prioritizableTest.getUniformPath().toString());
        this.selectionReason = (ETestSelectionReason)((Object)CollectionUtils.getAny(prioritizableTest.getSelectionReasons()));
        this.partition = prioritizableTest.getPartition();
        this.numberOfCoveredMethods = (int)prioritizableTest.getNumberOfCoveredMethods();
        if (prioritizableTest.isDurationSet()) {
            this.durationInMs = prioritizableTest.getDurationInMs(0L);
        }
        this.currentScore = prioritizableTest.getCurrentScore();
        this.numberOfAdditionallyCoveredMethods = prioritizableTest.getNumberOfAdditionallyCoveredMethods();
        this.rank = prioritizableTest.getRank();
    }

    public static List<PrioritizableTestPre80> from(List<PrioritizableTest> prioritizableTests) {
        return CollectionUtils.filterAndMap(prioritizableTests, prioritizableTest -> prioritizableTest.getUniformPath().isTestExecutionPath(), PrioritizableTestPre80::new);
    }
}

