/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ShallowEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EShallowEntityType type;
    private final String subtype;
    private @Nullable String name;
    private ShallowEntity parent;
    private final List<ShallowEntity> children = new ArrayList<ShallowEntity>();
    protected boolean completed = false;
    private final List<IToken> tokens;
    private int startTokenIndex;
    private int endTokenIndex = -1;
    private boolean continuedNode = false;

    public ShallowEntity(EShallowEntityType type, String subtype, String name, List<IToken> tokens, int startTokenIndex) {
        this.type = type;
        this.subtype = subtype;
        this.name = name;
        this.tokens = tokens;
        this.startTokenIndex = startTokenIndex;
    }

    public ShallowEntity(EShallowEntityType type, String subtype, String name, List<IToken> tokens, int startTokenIndex, int endTokenIndex, boolean completed, boolean continuedNode, List<ShallowEntity> children) {
        this(type, subtype, name, tokens, startTokenIndex);
        this.endTokenIndex = endTokenIndex;
        this.completed = completed;
        this.continuedNode = continuedNode;
        for (ShallowEntity child : children) {
            this.addChild(child);
        }
    }

    public int getEntityCount() {
        int result = 1;
        for (ShallowEntity child : this.children) {
            result += child.getEntityCount();
        }
        return result;
    }

    public int getCompleteEntityCount() {
        int result = 0;
        if (this.isCompleted()) {
            result = 1;
        }
        for (ShallowEntity child : this.children) {
            result += child.getCompleteEntityCount();
        }
        return result;
    }

    public EShallowEntityType getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public @Nullable String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public UnmodifiableList<ShallowEntity> getChildren() {
        return CollectionUtils.asUnmodifiable(this.children);
    }

    public void addChild(ShallowEntity child) {
        CCSMAssert.isTrue((child.parent == null ? 1 : 0) != 0, (String)"May not add entity to multiple parents!");
        this.children.add(child);
        child.parent = this;
    }

    public @Nullable ShallowEntity getParent() {
        return this.parent;
    }

    public List<ShallowEntity> getChildrenOfType(EShallowEntityType type) {
        ArrayList<ShallowEntity> result = new ArrayList<ShallowEntity>();
        for (ShallowEntity child : this.children) {
            if (child.getType() != type) continue;
            result.add(child);
        }
        return result;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    void setComplete(boolean continuedNode) {
        this.setComplete();
        this.continuedNode = continuedNode;
    }

    public void setComplete() {
        this.completed = true;
    }

    public boolean isContinued() {
        return this.continuedNode;
    }

    public void setEndTokenIndex(int endTokenIndex) {
        this.endTokenIndex = endTokenIndex;
    }

    public void setStartTokenIndex(int startTokenIndex) {
        this.startTokenIndex = startTokenIndex;
    }

    public int getStartTokenIndex() {
        return this.startTokenIndex;
    }

    public int getRelativeStartTokenIndex() {
        if (this.parent == null) {
            return this.getStartTokenIndex();
        }
        return this.getStartTokenIndex() - this.parent.getStartTokenIndex();
    }

    public int getRelativeEndTokenIndex() {
        if (this.parent == null) {
            return this.getEndTokenIndex();
        }
        return this.getEndTokenIndex() - this.parent.getStartTokenIndex();
    }

    public int getStartLine() {
        return this.getStartToken().getLineNumber() + 1;
    }

    public LineBasedRegion getLineBasedRegion() {
        return new LineBasedRegion(this.getStartLine(), this.getEndLine());
    }

    private IToken getStartToken() {
        CCSMAssert.isTrue((boolean)this.hasValidStartToken(), (String)("Start token index '" + this.getStartTokenIndex() + "' out of bounds for token list of length '" + this.tokens.size() + "' for entity " + String.valueOf((Object)this.getType()) + ":" + this.getSubtype() + ":" + this.getName()));
        return this.tokens.get(this.getStartTokenIndex());
    }

    public boolean hasValidStartToken() {
        return this.getStartTokenIndex() < this.tokens.size();
    }

    public int getStartOffset() {
        return this.getStartToken().getOffset();
    }

    public int getEndOffset() {
        IToken endToken = this.getEndToken();
        if (endToken == null) {
            return this.getStartToken().getEndOffset();
        }
        return endToken.getEndOffset();
    }

    public int getEndTokenIndex() {
        return this.endTokenIndex;
    }

    public int getEndLine() {
        IToken endToken = this.getEndToken();
        if (endToken == null) {
            return this.getStartToken().getLineNumber() + 1;
        }
        return endToken.getLineNumber() + 1;
    }

    private IToken getEndToken() {
        if (this.getEndTokenIndex() <= 0) {
            return null;
        }
        return this.tokens.get(this.getEndTokenIndex() - 1);
    }

    public UnmodifiableList<IToken> includedTokens() {
        return this.readOnlyTokenView(this.getStartTokenIndex(), this.getEndTokenIndex());
    }

    public boolean isEmpty() {
        return this.getEndTokenIndex() <= this.getStartTokenIndex();
    }

    private UnmodifiableList<IToken> readOnlyTokenView(int startIndex, int endIndex) {
        if ((endIndex = Math.min(endIndex, this.tokens.size())) <= startIndex || startIndex < 0) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.asUnmodifiable(this.tokens.subList(startIndex, endIndex));
    }

    public List<UnmodifiableList<IToken>> ownTokens() {
        ArrayList<UnmodifiableList<IToken>> ownTokens = new ArrayList<UnmodifiableList<IToken>>();
        int currentTokensBegin = this.getStartTokenIndex();
        for (ShallowEntity child : this.children) {
            ownTokens.add(this.readOnlyTokenView(currentTokensBegin, child.getStartTokenIndex()));
            currentTokensBegin = child.getEndTokenIndex();
        }
        UnmodifiableList<IToken> interval = this.readOnlyTokenView(currentTokensBegin, this.getEndTokenIndex());
        if (!interval.isEmpty()) {
            ownTokens.add(interval);
        }
        return ownTokens;
    }

    public UnmodifiableList<IToken> ownStartTokens() {
        if (this.children.isEmpty()) {
            return this.includedTokens();
        }
        HashSet subTypeNames = CollectionUtils.asHashSet((Object[])new String[]{"if", "while"});
        String subTypeOfFirstChild = this.children.get(0).getSubtype();
        if (subTypeNames.contains(this.subtype) && ("lambda".equals(subTypeOfFirstChild) || "lambda expression".equals(subTypeOfFirstChild) || "block expression".equals(subTypeOfFirstChild))) {
            for (ShallowEntity child : this.children) {
                int childStartIndex = child.getStartTokenIndex();
                if (ETokenType.LBRACE != this.tokens.get(childStartIndex - 1).getType()) continue;
                return this.readOnlyTokenView(this.getStartTokenIndex(), childStartIndex);
            }
        }
        return this.readOnlyTokenView(this.getStartTokenIndex(), this.children.get(0).getStartTokenIndex());
    }

    public UnmodifiableList<IToken> ownEndTokens() {
        if (this.children.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        HashSet subTypeNames = CollectionUtils.asHashSet((Object[])new String[]{"do", "do while"});
        String subTypeOfLastChild = ((ShallowEntity)CollectionUtils.getLast(this.children)).getSubtype();
        if (subTypeNames.contains(this.subtype) && this.isCompleted() && ("lambda".equals(subTypeOfLastChild) || "lambda expression".equals(subTypeOfLastChild) || "block expression".equals(subTypeOfLastChild))) {
            for (ShallowEntity child : CollectionUtils.reverse(this.children)) {
                int childEndIndex = child.getEndTokenIndex();
                ETokenType endToken = this.tokens.get(childEndIndex).getType();
                ETokenType oneAfterEndToken = this.tokens.get(childEndIndex + 1).getType();
                if (endToken != ETokenType.RBRACE || oneAfterEndToken != ETokenType.WHILE) continue;
                return this.readOnlyTokenView(childEndIndex, this.getEndTokenIndex());
            }
        }
        return this.readOnlyTokenView(((ShallowEntity)CollectionUtils.getLast(this.children)).getEndTokenIndex(), this.getEndTokenIndex());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsIndentedString(sb, 0);
        return sb.toString();
    }

    public String toLocalString() {
        return this.toLocalString(this.getStartLine(), this.getEndLine());
    }

    private String toLocalString(int startLine, int endLine) {
        String incomplete = "";
        if (!this.isCompleted()) {
            incomplete = " [incomplete]";
        }
        return String.valueOf((Object)this.type) + ": " + this.subtype + ": " + this.name + " (lines " + startLine + "-" + endLine + ")" + incomplete;
    }

    private void appendAsIndentedString(StringBuilder sb, int indent) {
        sb.append(StringUtils.fillString((int)(2 * indent), (char)' ')).append(this.toLocalString()).append(StringUtils.LINE_SEPARATOR);
        for (ShallowEntity child : this.children) {
            child.appendAsIndentedString(sb, indent + 1);
        }
    }

    public void traverse(IShallowEntityVisitor visitor) {
        if (visitor.visit(this)) {
            ShallowEntity.traverse(this.children, visitor);
        }
        visitor.endVisit(this);
    }

    public static void traverse(Collection<ShallowEntity> entities, IShallowEntityVisitor visitor) {
        for (ShallowEntity entity : entities) {
            entity.traverse(visitor);
        }
    }

    public static void filterTokens(Collection<ShallowEntity> entities, Predicate<IToken> predicate) {
        if (entities.isEmpty()) {
            return;
        }
        List<IToken> tokens = ((ShallowEntity)CollectionUtils.getAny(entities)).tokens;
        ArrayList<IToken> newTokens = new ArrayList<IToken>();
        ArrayList<Integer> indexLookup = new ArrayList<Integer>();
        for (IToken token : tokens) {
            indexLookup.add(newTokens.size());
            if (predicate.test(token)) continue;
            newTokens.add(token);
        }
        indexLookup.add(newTokens.size());
        tokens.clear();
        tokens.addAll(newTokens);
        ShallowEntity.traverse(entities, entity -> {
            entity.startTokenIndex = (Integer)indexLookup.get(entity.startTokenIndex);
            if (entity.getEndTokenIndex() >= 0) {
                entity.endTokenIndex = (Integer)indexLookup.get(entity.getEndTokenIndex());
            }
            return true;
        });
    }

    public ShallowEntity deepCloneWithoutCloningTokens(List<IToken> tokens) {
        ShallowEntity clone = new ShallowEntity(this.getType(), this.getSubtype(), this.getName(), tokens, this.startTokenIndex);
        clone.endTokenIndex = this.getEndTokenIndex();
        clone.completed = this.completed;
        clone.continuedNode = this.continuedNode;
        for (ShallowEntity child : this.getChildren()) {
            ShallowEntity clonedChild = child.deepCloneWithoutCloningTokens(tokens);
            clone.addChild(clonedChild);
            clonedChild.parent = clone;
        }
        return clone;
    }

    public static void collapseEmptyEntities(Collection<ShallowEntity> entities) {
        ArrayList<ShallowEntity> result = new ArrayList<ShallowEntity>();
        for (ShallowEntity entity : entities) {
            entity.collapseEmptyEntities();
            if (entity.isCollapsible()) {
                result.addAll(entity.children);
                continue;
            }
            result.add(entity);
        }
        entities.clear();
        entities.addAll(result);
    }

    private void collapseEmptyEntities() {
        for (ShallowEntity child : this.children) {
            child.collapseEmptyEntities();
        }
        ArrayList<ShallowEntity> newChildren = new ArrayList<ShallowEntity>();
        for (ShallowEntity child : this.children) {
            if (child.isCollapsible()) {
                for (ShallowEntity subChild : child.children) {
                    newChildren.add(subChild);
                    subChild.parent = this;
                }
                continue;
            }
            newChildren.add(child);
        }
        this.children.clear();
        this.children.addAll(newChildren);
    }

    private boolean isCollapsible() {
        return this.readOnlyTokenView(this.getStartTokenIndex(), this.getEndTokenIndex()).isEmpty();
    }

    public List<IToken> getAllTokensOfFile() {
        return this.tokens;
    }
}

