/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.cache;

import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.service.framework.impl.cache.ServerCache;
import com.teamscale.service.framework.impl.cache.ServerCacheHitFilter;
import jakarta.annotation.Priority;
import jakarta.inject.Provider;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.InterceptorContext;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

@Priority(value=3000)
public class ServerCacheInterceptor
implements WriterInterceptor {
    protected static final String DO_NOT_CACHE_AND_ENCODE_RESPONSE = "DO NOT CACHE AND ENCODE RESPONSE";
    private static final UnmodifiableSet<String> NO_STORE_HEADERS = CollectionUtils.asUnmodifiable(Set.of("Set-Cookie"));
    private final ServerCache cache = ServerCache.getInstance();
    @Context
    private Request request;
    @Context
    private Provider<ContainerRequestContext> requestProvider;

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        ContainerRequestContext request = (ContainerRequestContext)this.requestProvider.get();
        if (!request.getMethod().equalsIgnoreCase("GET") && !request.getMethod().equalsIgnoreCase("HEAD") || ServerCacheInterceptor.isCachedResponse((InterceptorContext)context)) {
            context.proceed();
            return;
        }
        CacheControl cacheControl = (CacheControl)context.getHeaders().getFirst((Object)"Cache-Control");
        if (cacheControl == null || cacheControl.isNoCache()) {
            context.proceed();
            return;
        }
        this.saveResponseToCache(context, request, cacheControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveResponseToCache(WriterInterceptorContext context, ContainerRequestContext request, CacheControl cacheControl) throws IOException {
        OutputStream oldStream = context.getOutputStream();
        try {
            byte[] entity = ServerCacheInterceptor.getEncodedEntity(context);
            this.processCacheableEntity(context, request, cacheControl, entity);
            oldStream.write(entity);
            oldStream.flush();
        }
        finally {
            context.setOutputStream(oldStream);
        }
    }

    private static byte[] getEncodedEntity(WriterInterceptorContext context) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        context.setOutputStream((OutputStream)byteBuffer);
        context.proceed();
        OutputStream encodingOutputStream = context.getOutputStream();
        encodingOutputStream.flush();
        encodingOutputStream.close();
        return byteBuffer.toByteArray();
    }

    private void processCacheableEntity(WriterInterceptorContext context, ContainerRequestContext request, CacheControl cacheControl, byte[] entity) {
        EntityTag eTag = ServerCacheInterceptor.computeAndSetETag(context, entity);
        this.saveResponseToCache(context, request, cacheControl, entity, eTag);
        Response.ResponseBuilder validatedResponse = ServerCacheHitFilter.safeEvaluatePreconditions(eTag, this.request);
        if (validatedResponse != null) {
            throw new WebApplicationException(validatedResponse.status(Response.Status.NOT_MODIFIED).cacheControl(cacheControl).header("ETag", (Object)eTag).build());
        }
    }

    private void saveResponseToCache(WriterInterceptorContext context, ContainerRequestContext request, CacheControl cacheControl, byte[] entity, EntityTag eTag) {
        if (cacheControl.isPrivate() || cacheControl.isNoStore()) {
            return;
        }
        MultivaluedMap<String, String> varyHeaders = ServerCacheInterceptor.getVaryHeaders(context, request);
        MultivaluedMap<String, Object> filteredHeaders = ServerCacheInterceptor.getFilteredStoreHeaders(context);
        this.cache.add(request.getUriInfo().getRequestUri().toString(), context.getMediaType(), cacheControl, filteredHeaders, entity, eTag, varyHeaders);
    }

    private static MultivaluedMap<String, Object> getFilteredStoreHeaders(WriterInterceptorContext context) {
        MultivaluedMap headers = context.getHeaders();
        if (NO_STORE_HEADERS.stream().noneMatch(arg_0 -> headers.containsKey(arg_0))) {
            return headers;
        }
        MultivaluedHashMap filteredHeaders = new MultivaluedHashMap(headers);
        NO_STORE_HEADERS.forEach(arg_0 -> ((MultivaluedMap)filteredHeaders).remove(arg_0));
        return filteredHeaders;
    }

    private static MultivaluedMap<String, String> getVaryHeaders(WriterInterceptorContext context, ContainerRequestContext request) {
        MultivaluedHashMap varyHeaders = new MultivaluedHashMap();
        if (context.getHeaders().containsKey((Object)"Vary")) {
            for (Object varyHeader : (List)context.getHeaders().get((Object)"Vary")) {
                String varyHeaderString = varyHeader.toString();
                if (!request.getHeaders().containsKey((Object)varyHeaderString)) continue;
                varyHeaders.addAll((Object)varyHeaderString, (List)request.getHeaders().get((Object)varyHeaderString));
            }
        }
        return varyHeaders;
    }

    private static EntityTag computeAndSetETag(WriterInterceptorContext context, byte[] entity) {
        Object eTagObject = context.getHeaders().getFirst((Object)"ETag");
        if (eTagObject != null) {
            if (eTagObject instanceof EntityTag) {
                return (EntityTag)eTagObject;
            }
            return new EntityTag(eTagObject.toString());
        }
        EntityTag eTag = new EntityTag(Long.toHexString(XXHashUtils.xxhash64((byte[])entity)));
        context.getHeaders().putSingle((Object)"ETag", (Object)eTag);
        return eTag;
    }

    private static boolean isCachedResponse(InterceptorContext context) {
        return context.getProperty(DO_NOT_CACHE_AND_ENCODE_RESPONSE) != null;
    }

    public static boolean isCachedResponse(ContainerRequestContext context) {
        return context.getProperty(DO_NOT_CACHE_AND_ENCODE_RESPONSE) != null;
    }
}

