/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.versioning;

import com.teamscale.service.framework.versioning.ILegacyUsageDataProvider;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;

public class LegacyServiceFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean legacyServiceUsed = false;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        legacyServiceUsed = true;
        LOGGER.error("Service {} {} is deprecated. It will be removed in an upcoming version. Please refer to the API reference for alternatives.", (Object)requestContext.getMethod(), (Object)requestContext.getUriInfo().getPath());
        if (!EFeatureToggle.ENABLE_LEGACY_API.isEnabled()) {
            LOGGER.error("Service is disabled. To temporarily re-enable it, set the system property '{}' to 'true'.", (Object)EFeatureToggle.ENABLE_LEGACY_API.getId());
            requestContext.abortWith(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
    }

    public static class LegacyUsageDataProvider
    implements ILegacyUsageDataProvider {
        public boolean wasLegacyServiceUsed() {
            return legacyServiceUsed;
        }
    }
}

