/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.versioning;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.service.framework.util.ServiceAnnotationUtils;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.framework.versioning.VersionedMediaTypeUtils;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;

@Provider
public class VersionRoutingHandler
implements ModelProcessor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<MediaType> ALL_PRODUCED_MEDIA_TYPES = new CopyOnWriteArraySet<MediaType>();

    static UnmodifiableSet<MediaType> getAllVersionedProducedMediaTypes() {
        return CollectionUtils.asUnmodifiable(ALL_PRODUCED_MEDIA_TYPES);
    }

    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        return VersionRoutingHandler.modifyResourceModel(resourceModel, false);
    }

    private static ResourceModel modifyResourceModel(ResourceModel resourceModel, boolean subResourceModel) {
        ResourceModel.Builder newResourceModelBuilder = new ResourceModel.Builder(subResourceModel);
        for (Resource resource : resourceModel.getResources()) {
            newResourceModelBuilder.addResource(VersionRoutingHandler.modifyResource(resource));
        }
        return newResourceModelBuilder.build();
    }

    private static Resource modifyResource(Resource resource) {
        Resource.Builder resourceBuilder = Resource.builder((Resource)resource);
        VersionRoutingHandler.checkForSubResourceLocator(resource);
        for (ResourceMethod method : resource.getResourceMethods()) {
            ResourceMethod.Builder builder = resourceBuilder.updateMethod(method);
            VersionRoutingHandler.appendDefaultMediaTypes(method, builder);
            Optional publicApiAnnotation = ServiceAnnotationUtils.getMethodAnnotation(PublicApi.class, (Method)method.getInvocable().getDefinitionMethod());
            if (publicApiAnnotation.isEmpty()) {
                ResourceMethod built = builder.build();
                VersionRoutingHandler.registerProducedMediaTypes(built.getProducedTypes(), built, false);
                continue;
            }
            VersionRoutingHandler.appendVersionedMediaTypes(builder, method, (PublicApi)publicApiAnnotation.get());
        }
        for (Resource childResource : resource.getChildResources()) {
            resourceBuilder.replaceChildResource(childResource, VersionRoutingHandler.modifyResource(childResource));
        }
        return resourceBuilder.build();
    }

    private static void checkForSubResourceLocator(Resource resource) {
        Method definitionMethod;
        Optional publicApiAnnotation;
        ResourceMethod resourceLocator = resource.getResourceLocator();
        if (resourceLocator != null && (publicApiAnnotation = ServiceAnnotationUtils.getMethodAnnotation(PublicApi.class, (Method)(definitionMethod = resourceLocator.getInvocable().getDefinitionMethod()))).isPresent()) {
            LOGGER.warn("@PublicApi is not supported on sub-resource locator: {}", (Object)definitionMethod);
        }
    }

    private static void appendDefaultMediaTypes(ResourceMethod method, ResourceMethod.Builder builder) {
        Method definitionMethod = method.getInvocable().getDefinitionMethod();
        if (method.getProducedTypes().isEmpty()) {
            builder.produces((Collection)VersionedMediaTypeUtils.getDefaultProducedMediaTypes((Method)definitionMethod));
        }
        if (method.getConsumedTypes().isEmpty()) {
            builder.consumes((Collection)VersionedMediaTypeUtils.getDefaultConsumedMediaTypes((Method)definitionMethod));
        }
    }

    private static void appendVersionedMediaTypes(ResourceMethod.Builder builder, ResourceMethod method, PublicApi publicApiAnnotation) {
        List producedTypes = method.getProducedTypes();
        if (producedTypes.isEmpty()) {
            producedTypes = VersionedMediaTypeUtils.getInferredProducedTypesFromReturnType((Method)method.getInvocable().getDefinitionMethod());
        }
        VersionRoutingHandler.registerProducedMediaTypes(producedTypes, method, true);
        builder.produces(VersionRoutingHandler.convertToVersionedMediaTypes(publicApiAnnotation, producedTypes));
    }

    private static void registerProducedMediaTypes(Collection<MediaType> producedTypes, ResourceMethod method, boolean failOnWildcard) {
        if (failOnWildcard) {
            CCSMAssert.isFalse((boolean)producedTypes.stream().anyMatch(mediaType -> mediaType.isWildcardType() || mediaType.isWildcardSubtype()), () -> "Method %s produces a wildcard type. This is not supported for versioned services, please use concrete types.".formatted(method.getInvocable().getDefinitionMethod()));
        } else {
            producedTypes = CollectionUtils.filter(producedTypes, type -> !type.isWildcardType() && !type.isWildcardSubtype());
        }
        ALL_PRODUCED_MEDIA_TYPES.addAll(producedTypes);
    }

    private static Set<MediaType> convertToVersionedMediaTypes(PublicApi publicApiAnnotation, List<MediaType> mediaTypes) {
        HashSet<MediaType> versionedMediaTypes = new HashSet<MediaType>();
        ETeamscaleVersion version = publicApiAnnotation.since();
        do {
            versionedMediaTypes.addAll(VersionedMediaTypeUtils.convertToVersionedMediaTypes(mediaTypes, (ETeamscaleVersion)version));
        } while ((version = (ETeamscaleVersion)version.next().orElse(null)) != null && version != publicApiAnnotation.deprecatedSince());
        return versionedMediaTypes;
    }

    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        return VersionRoutingHandler.modifyResourceModel(subResourceModel, true);
    }
}

