/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.writer;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.stream.Stream;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.commons.util.NullableFieldValidator;
import org.conqat.engine.commons.util.SerializationViews;
import org.conqat.engine.core.core.ConQATException;

@Provider
public class JsonSerializer
extends JacksonJsonProvider {
    @Context
    protected jakarta.inject.Provider<ResourceInfo> resourceInfoProvider;
    public static final String MEDIA_SUB_TYPE = "json";

    public JsonSerializer() {
        this.setMapper(JsonUtils.getObjectMapper());
        this.setDefaultView(SerializationViews.DefaultView.class);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            Object object = super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
            if (object == null && !JsonSerializer.isBodyRequired(annotations)) {
                return null;
            }
            NullableFieldValidator.ensureAllFieldsNonNull((Object)object);
            return object;
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new BadRequestException("Cannot parse JSON because of mismatched input data", e);
        }
        catch (ConQATException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isBodyRequired(Annotation[] annotations) {
        Optional<Annotation> requestBodyAnnotation = Stream.of(annotations).filter(annotation -> annotation.annotationType() == RequestBody.class).findFirst();
        if (requestBodyAnnotation.isEmpty()) {
            return true;
        }
        RequestBody requestBody = (RequestBody)requestBodyAnnotation.get();
        return requestBody.required();
    }
}

