/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.simulink.builder.ModelBuildingParameters;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.datahandler.GotoFromResolver;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLayoutHandler;
import org.conqat.lib.simulink.model.datahandler.stateflow.StateflowLayoutHandler;

public class ModelDataHandler {
    private final List<File> referenceDirectories;
    private final String parentBlockId;
    private final String discardedPrefix;
    private final SimulinkLayoutHandler simulinkLayoutHandler;
    private final StateflowLayoutHandler stateflowLayoutHandler;

    ModelDataHandler(ModelBuildingParameters parameters, SimulinkLayoutHandler simulinkLayoutHandler, StateflowLayoutHandler stateflowLayoutHandler) {
        this.simulinkLayoutHandler = simulinkLayoutHandler;
        this.stateflowLayoutHandler = stateflowLayoutHandler;
        this.parentBlockId = parameters.getParentBlockId();
        this.discardedPrefix = parameters.getDiscardedPrefix();
        this.referenceDirectories = new ArrayList<File>(parameters.getReferencePaths());
    }

    public ModelDataHandler(ModelDataHandler other, String parentBlockId, String discardedPrefix) {
        this.simulinkLayoutHandler = other.simulinkLayoutHandler;
        this.stateflowLayoutHandler = other.stateflowLayoutHandler;
        this.parentBlockId = parentBlockId;
        this.discardedPrefix = discardedPrefix;
        this.referenceDirectories = new ArrayList<File>(other.referenceDirectories);
    }

    public UnmodifiableList<File> getReferenceDirectories() {
        return CollectionUtils.asUnmodifiable(this.referenceDirectories);
    }

    public String getParentBlockId() {
        return this.parentBlockId;
    }

    public String getDiscardedPrefix() {
        return this.discardedPrefix;
    }

    public SimulinkLayoutHandler getSimulinkLayoutHandler() {
        return this.simulinkLayoutHandler;
    }

    public StateflowLayoutHandler getStateflowLayoutHandler() {
        return this.stateflowLayoutHandler;
    }

    public static GotoFromResolver createGotoFromResolver(SimulinkBlock rootBlock) {
        return new GotoFromResolver(rootBlock);
    }
}

