/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import com.teamscale.commons.annotation.ClassIndexUtils;
import com.teamscale.jsbuild.JsBuildException;
import com.teamscale.jsbuild.export.ExportTypeException;
import com.teamscale.jsbuild.export.ExportedTypeScriptClass;
import com.teamscale.jsbuild.export.ExportedTypeScriptClassGenerator;
import com.teamscale.jsbuild.export.JavaToTypeScriptClassExporter;
import com.teamscale.jsbuild.export.TsClassGeneratorBase;
import com.teamscale.jsbuild.module.EnumJavaScriptGenerationUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

public class DataClassGenerator
extends TsClassGeneratorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Class<?>> exportedClassesAndEnums = new ArrayList();

    public DataClassGenerator(File typedefsFolder) {
        super(typedefsFolder);
        ClassIndexUtils.getAnnotated(ExportToTypeScript.class).forEach(e -> {
            if (!e.getPackage().getName().startsWith(JsBuildException.class.getPackage().getName())) {
                this.exportedClassesAndEnums.add((Class<?>)e);
            }
        });
    }

    @Override
    public void generateFiles() {
        LOGGER.info("Export of Java classes to TypeScript...");
        try {
            List classesToExport = CollectionUtils.filter(this.exportedClassesAndEnums, aClass -> !aClass.isEnum());
            List enumsToExport = CollectionUtils.filter(this.exportedClassesAndEnums, Class::isEnum);
            this.exportClasses(classesToExport);
            this.exportEnums(enumsToExport);
        }
        catch (ExportTypeException | IOException e) {
            LOGGER.error("Error exporting Java classes to TypeScript.", (Throwable)e);
        }
    }

    private void exportClasses(List<Class<?>> exportedClasses) throws ExportTypeException, IOException {
        if (exportedClasses.isEmpty()) {
            LOGGER.warn("No Java classes for generating TypeScript type definitions found.");
            return;
        }
        Collection<ExportedTypeScriptClass> typesForExport = JavaToTypeScriptClassExporter.getExportedTypeScriptClasses(exportedClasses);
        for (ExportedTypeScriptClass exportedClass : typesForExport) {
            String generatedClassJs = new ExportedTypeScriptClassGenerator(exportedClass).build();
            this.addGeneratedJavaScript(exportedClass.getSimpleClassName(), generatedClassJs);
        }
    }

    private void exportEnums(List<Class<?>> enums) throws IOException {
        if (enums.isEmpty()) {
            LOGGER.warn("No Java enums for generating TypeScript type definitions found.");
        }
        for (Class<?> exportedEnum : enums) {
            CCSMAssert.isTrue((boolean)exportedEnum.isEnum(), (String)"Expected only enums at this point");
            String generatedContent = EnumJavaScriptGenerationUtils.generateEnumJS(exportedEnum);
            this.addGeneratedJavaScript(exportedEnum.getSimpleName(), generatedContent);
        }
    }
}

