/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.module;

import com.teamscale.jsbuild.JsBuildException;
import com.teamscale.jsbuild.export.ExportTypeException;
import com.teamscale.jsbuild.export.GenericCollectionFieldExporter;
import com.teamscale.jsbuild.export.JavaToTypeScriptClassExporter;
import com.teamscale.jsbuild.export.TypeScriptImportStatement;
import com.teamscale.jsbuild.export.TypescriptType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.js_export.ExportAsType;
import org.conqat.lib.commons.js_export.NotExported;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class EnumJavaScriptGenerationUtils {
    private static final String NAME_FIELD = "name";

    public static <T> String generateEnumFromInstances(Class<T> instanceClass, Collection<? extends T> instances, String enumName, Function<T, String> literalNameProvider) throws JsBuildException {
        StringBuilder builder = new StringBuilder();
        List<Field> fields = EnumJavaScriptGenerationUtils.getRelevantEnumFields(instanceClass);
        builder.append(EnumJavaScriptGenerationUtils.createEnumHead(enumName));
        int count = 0;
        for (T value : instances) {
            if (EnumJavaScriptGenerationUtils.isIgnoredEnumField(instanceClass, value)) continue;
            builder.append(EnumJavaScriptGenerationUtils.generateEnumValue(enumName, value, fields, literalNameProvider, count));
            builder.append("\n");
            ++count;
        }
        List<String> entryNames = EnumJavaScriptGenerationUtils.appendValuesArray(instanceClass, enumName, instances, literalNameProvider, builder);
        EnumJavaScriptGenerationUtils.insertEnumEntryTypeAtTop(enumName, entryNames, builder);
        EnumJavaScriptGenerationUtils.insertImportStatementsAtTop(builder, fields);
        EnumJavaScriptGenerationUtils.exportStaticEnumCollections(instanceClass, enumName, builder);
        builder.append(EnumJavaScriptGenerationUtils.generateEnumConstructor(enumName, fields));
        builder.append(EnumJavaScriptGenerationUtils.generateEnumToString());
        builder.append(EnumJavaScriptGenerationUtils.generateEnumValueOf(enumName));
        builder.append("}").append("\n").append("\n");
        builder.insert(0, "/** Generated from " + enumName + ".java. Do not modify this file! */\n\n");
        return builder.toString();
    }

    private static void insertEnumEntryTypeAtTop(String enumName, List<String> names, StringBuilder builder) {
        String entryDeclaration = "\nexport type " + EnumJavaScriptGenerationUtils.getNameTypeDefinitionName(enumName) + " = " + String.join((CharSequence)" | ", names) + ";\n\n";
        builder.insert(0, entryDeclaration);
    }

    public static @NonNull String getNameTypeDefinitionName(String enumName) {
        return enumName + "Entry";
    }

    private static <T> boolean isIgnoredEnumField(Class<T> instanceClass, T value) {
        try {
            return value instanceof Enum && instanceClass.getField(((Enum)value).name()).isAnnotationPresent(NotExported.class);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private static void insertImportStatementsAtTop(StringBuilder builder, List<Field> fields) {
        HashSet<TypeScriptImportStatement> imports = new HashSet<TypeScriptImportStatement>();
        for (Field field : fields) {
            Class<?> typeOfField = field.getType();
            if (typeOfField.getTypeParameters().length > 0 && Collection.class.isAssignableFrom(typeOfField)) {
                EnumJavaScriptGenerationUtils.handleImportsForCollectionField(imports, field);
                continue;
            }
            if (!EnumJavaScriptGenerationUtils.needsToImportOtherTypeForField(typeOfField)) continue;
            EnumJavaScriptGenerationUtils.handleImportsForNonCollectionField(imports, field, typeOfField);
        }
        imports.forEach(importStatement -> builder.insert(0, importStatement.toCode()));
    }

    private static void handleImportsForCollectionField(Set<TypeScriptImportStatement> imports, Field field) {
        Class genericType = (Class)GenericCollectionFieldExporter.resolveGenericType((AnnotatedParameterizedType)field.getAnnotatedType(), 0, field).getFirst();
        if (EnumJavaScriptGenerationUtils.needsToImportOtherTypeForField(genericType)) {
            if (genericType.isEnum()) {
                imports.add(new TypeScriptImportStatement("typedefs/" + genericType.getSimpleName(), EnumJavaScriptGenerationUtils.getNameTypeDefinitionName(genericType.getSimpleName()), !EnumJavaScriptGenerationUtils.isExportedEnumField(field, genericType)));
            } else {
                imports.add(new TypeScriptImportStatement("typedefs/" + genericType.getSimpleName(), !EnumJavaScriptGenerationUtils.isExportedEnumField(field, genericType)));
            }
        }
    }

    private static void handleImportsForNonCollectionField(Set<TypeScriptImportStatement> imports, Field field, Class<?> typeOfField) {
        if (typeOfField.isEnum() && !EnumJavaScriptGenerationUtils.isExportedEnumField(field, typeOfField)) {
            imports.add(new TypeScriptImportStatement("typedefs/" + typeOfField.getSimpleName(), EnumJavaScriptGenerationUtils.getNameTypeDefinitionName(typeOfField.getSimpleName()), true));
        } else {
            imports.add(new TypeScriptImportStatement("typedefs/" + typeOfField.getSimpleName(), !EnumJavaScriptGenerationUtils.isExportedEnumField(field, typeOfField)));
        }
    }

    private static boolean needsToImportOtherTypeForField(Class<?> fieldType) {
        return EnumJavaScriptGenerationUtils.shouldExportFieldWithType(fieldType) && !fieldType.isPrimitive() && !fieldType.isArray() && !fieldType.getName().startsWith("java.");
    }

    private static <T> void exportStaticEnumCollections(Class<T> instanceClass, String enumName, StringBuilder builder) throws JsBuildException {
        for (Field field : instanceClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            EnumJavaScriptGenerationUtils.exportStaticField(instanceClass, enumName, builder, field);
        }
    }

    private static <T> void exportStaticField(Class<T> instanceClass, String enumName, StringBuilder builder, Field field) throws JsBuildException {
        Class<?> fieldType = field.getType();
        if (!List.class.isAssignableFrom(fieldType) && !Set.class.isAssignableFrom(fieldType)) {
            return;
        }
        ParameterizedType type = (ParameterizedType)field.getGenericType();
        if (!((Class)type.getActualTypeArguments()[0]).isEnum()) {
            return;
        }
        field.setAccessible(true);
        try {
            List enumNames = CollectionUtils.map((Collection)((Collection)field.get(instanceClass)), Enum::name);
            if (Set.class.isAssignableFrom(fieldType)) {
                enumNames = CollectionUtils.sort((Collection)enumNames);
            }
            EnumJavaScriptGenerationUtils.appendStaticArray(enumName, enumNames, builder, field.getName());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JsBuildException(e);
        }
    }

    public static <T extends Enum<?>> String generateEnumJS(Class<T> enumClass) throws JsBuildException {
        return EnumJavaScriptGenerationUtils.generateEnumFromInstances(enumClass, Arrays.asList((Enum[])enumClass.getEnumConstants()), enumClass.getSimpleName(), Enum::name);
    }

    private static String createEnumHead(String enumName) {
        return "export class " + enumName + " {\n";
    }

    private static List<Field> getRelevantEnumFields(Class<?> enumClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : enumClass.getDeclaredFields()) {
            if (!EnumJavaScriptGenerationUtils.isRelevantEnumField(field)) continue;
            field.setAccessible(true);
            fields.add(field);
        }
        return fields;
    }

    private static boolean isRelevantEnumField(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !field.isAnnotationPresent(NotExported.class);
    }

    private static boolean hasNameField(List<Field> fields) {
        for (Field field : fields) {
            if (!field.getName().equals(NAME_FIELD)) continue;
            return true;
        }
        return false;
    }

    private static <T> String generateEnumValue(String enumName, T value, List<Field> fields, Function<T, String> literalNameProvider, int ordinal) throws JsBuildException {
        StringBuilder valueBuilder = new StringBuilder();
        String literalName = literalNameProvider.apply(value);
        valueBuilder.append("\tstatic readonly ").append(literalName).append(" = ");
        valueBuilder.append("new ").append(enumName).append("(");
        valueBuilder.append(ordinal);
        if (!EnumJavaScriptGenerationUtils.hasNameField(fields)) {
            valueBuilder.append(", '").append(literalName).append("'");
        }
        for (Field field : fields) {
            if (!EnumJavaScriptGenerationUtils.shouldExportFieldWithType(field.getType())) continue;
            valueBuilder.append(", ");
            try {
                valueBuilder.append(EnumJavaScriptGenerationUtils.getFieldValue(field, value));
            }
            catch (IllegalAccessException e) {
                throw new JsBuildException("Unexpected access problems. Is there a security manager present?", e);
            }
        }
        valueBuilder.append(");");
        return valueBuilder.toString();
    }

    private static String generateEnumConstructor(String enumName, List<Field> fields) throws JsBuildException {
        StringBuilder valueBuilder = new StringBuilder();
        valueBuilder.append("\tprivate constructor ").append("(").append("\n");
        valueBuilder.append("\t\tpublic readonly ordinal: number,").append("\n");
        if (!EnumJavaScriptGenerationUtils.hasNameField(fields)) {
            valueBuilder.append("\t\tpublic readonly name: ").append(EnumJavaScriptGenerationUtils.getNameTypeDefinitionName(enumName)).append(",").append("\n");
        }
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (!EnumJavaScriptGenerationUtils.shouldExportFieldWithType(field.getType())) continue;
            valueBuilder.append("\t\tpublic readonly ").append(field.getName()).append(": ").append(EnumJavaScriptGenerationUtils.getJSType(field).toNullableType());
            if (i >= fields.size() - 1) continue;
            valueBuilder.append(",");
            valueBuilder.append("\n");
        }
        valueBuilder.append("\n").append("\t){\n\t}");
        return valueBuilder.toString();
    }

    private static String generateEnumToString() {
        return "\n\n\ttoString() {\n\t\treturn this.name;\n\t}\n";
    }

    private static String generateEnumValueOf(String enumName) {
        return "\n\t/** Returns the enum value of the provided enum entry. */\n\tpublic static valueOf(entry: %2$s): %1$s;\n\t/** Returns the enum value of the provided enum entry. Returns undefined if entry was undefined. */\n\tpublic static valueOf(entry: %2$s | undefined): %1$s | undefined;\n\tpublic static valueOf(entry: %2$s | undefined): %1$s | undefined {\n\t\tif (entry === undefined) {\n\t\t\treturn undefined;\n\t\t}\n\t\treturn %1$s[entry];\n\t}\n".formatted(enumName, EnumJavaScriptGenerationUtils.getNameTypeDefinitionName(enumName));
    }

    private static boolean shouldExportFieldWithType(Class<?> type) {
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if (type == String.class || type == Boolean.class || type.isEnum() || type.isPrimitive()) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return true;
        }
        return EnumJavaScriptGenerationUtils.isRecordType(type);
    }

    private static boolean isRecordType(Class<?> type) {
        return type.getSuperclass() != null && type.getSuperclass().getName().equals("java.lang.Record");
    }

    private static <T> Object getFieldValue(Field field, T value) throws IllegalArgumentException, IllegalAccessException {
        Object fieldValue = field.get(value);
        if (field.getType() == Object.class && Number.class.isAssignableFrom(fieldValue.getClass())) {
            return "{'value': " + String.valueOf(fieldValue) + "}";
        }
        if (EnumJavaScriptGenerationUtils.isExportedEnumField(field, field.getType())) {
            return field.getType().getSimpleName() + "." + String.valueOf(fieldValue);
        }
        return EnumJavaScriptGenerationUtils.toJson(fieldValue);
    }

    private static boolean isExportedEnumField(Field field, Class<?> typeToExport) {
        return typeToExport.isEnum() && field.getAnnotatedType().isAnnotationPresent(ExportAsType.class) && field.getAnnotatedType().getAnnotation(ExportAsType.class).value().equals(field.getType().getSimpleName());
    }

    private static String toJson(Object fieldValue) {
        return JsonUtils.serializeToJSON((Object)fieldValue);
    }

    private static <T> List<String> appendValuesArray(Class<T> instanceClass, String fullName, Collection<? extends T> enumConstants, Function<T, String> literalNameProvider, StringBuilder builder) {
        ArrayList<String> enumFields = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (T value : enumConstants) {
            if (EnumJavaScriptGenerationUtils.isIgnoredEnumField(instanceClass, value)) continue;
            String enumFieldName = literalNameProvider.apply(value);
            enumFields.add(enumFieldName);
            names.add("'" + StringUtils.getLastPart((String)enumFieldName, (String)".") + "'");
        }
        EnumJavaScriptGenerationUtils.appendValuesArray(fullName, enumFields, builder);
        builder.append("\n").append("\n");
        return names;
    }

    private static void appendValuesArray(String fullName, Collection<String> names, StringBuilder builder) {
        EnumJavaScriptGenerationUtils.appendStaticArray(fullName, names, builder, "values");
    }

    private static void appendStaticArray(@Nullable String enumName, Collection<String> names, StringBuilder builder, String arrayName) {
        builder.append("\tstatic readonly ").append(arrayName).append(" = [").append("\n");
        int count = 0;
        for (String name : names) {
            builder.append("\t\t");
            if (enumName != null) {
                builder.append(enumName).append(".");
            }
            builder.append(name);
            if (++count < names.size()) {
                builder.append(",");
            }
            builder.append("\n");
        }
        builder.append("\t];").append("\n").append("\n");
    }

    private static TypescriptType getJSType(Field field) throws JsBuildException {
        try {
            return JavaToTypeScriptClassExporter.getExportedType(field);
        }
        catch (ExportTypeException e) {
            throw new JsBuildException(e);
        }
    }

    private EnumJavaScriptGenerationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

