/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-call-to-external-form-routines", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoCallToExternalFormRoutinesCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"perform".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList entityTokens = entity.ownStartTokens();
        if (TokenStreamUtils.containsSequence((List)entityTokens, (int)0, (int)(entityTokens.size() - 1), (ITokenMatcher[])new ITokenMatcher[]{ETokenType.PERFORM, ETokenType.IDENTIFIER, ETokenType.IN, ETokenType.PROGRAM})) {
            this.buildFinding("External form subroutines should not be called", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

