/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cloud_smells.config;

import eu.cqse.check.cloud_smells.config.XmlAnyElementAttributeRegexCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

@Check(id="cqse-avoid-hard-coded-ip-adress-in-config-file", languages={ELanguage.XML})
public class HardCodedIPAddressInAttributeCheck
extends XmlAnyElementAttributeRegexCheckBase {
    protected static final String CHECK_NAME = "Hard Coded IP Address in Config File";
    @CheckOption(name="Hard Coded IP Address in Config File - Allowed IP addresses in config files", description="Using the IP addresses specified here is allowed. Separated by commas.")
    private Set<String> allowedIPAddresses = new HashSet<String>();
    @CheckOption(name="Hard Coded IP Address in Config File - Attributes not searched for IP addresses in config files", description="Using IP addresses in attributes with a name specified here is allowed. Separated by commas.")
    private Set<String> ignoredAttributes = new HashSet<String>();

    @Override
    protected boolean shouldIgnore(String elementName, String localAttributeName, String attributeValue, MatchResult matchResult) {
        return this.ignoredAttributes.contains(localAttributeName) || this.allowedIPAddresses.contains(matchResult.group(0));
    }

    @Override
    protected Pattern getUnwantedRegex() {
        return Pattern.compile("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");
    }

    @Override
    protected String getFindingText(String elementName, String localAttributeName, String attributeValue, MatchResult matchResult) {
        return CHECK_NAME;
    }
}

