/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Check(id="cqse-namespace-import", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NamespaceImportCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Namespaces should not be imported as a whole";
    @CheckOption(name="Namespaces should not be imported as a whole: Excluded namespaces", description="Comma-separated list of namespaces that can be imported as a whole without resulting in a finding.")
    private Set<String> excludedNamespaces = new HashSet<String>();
    private static final String CPP_NAMESPACE_SEPARATOR = "::";

    public void execute() throws CheckException {
        List metaEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.META);
        for (ShallowEntity metaEntity : metaEntities) {
            if (!"using namespace".equals(metaEntity.getSubtype())) continue;
            this.processEntity(metaEntity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        ArrayList tokens = new ArrayList(entity.includedTokens());
        int indexOfUsingNamespace = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.USING, ETokenType.NAMESPACE});
        int indexOfSemicolon = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.SEMICOLON);
        if (indexOfUsingNamespace == -1 || indexOfSemicolon == -1) {
            return;
        }
        List namespaceTokens = tokens.subList(indexOfUsingNamespace + 2, indexOfSemicolon);
        String namespace = TokenStreamTextUtils.concatTokenTexts(namespaceTokens);
        boolean containsNamespaceSeparator = namespace.contains(CPP_NAMESPACE_SEPARATOR);
        if (!this.excludedNamespaces.contains(namespace) && !containsNamespaceSeparator) {
            this.buildFinding("Do not import `" + entity.getName() + "` as a whole", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

