/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.arrays;

import eu.cqse.check.cpp.CppIntegerLiteralParser;
import eu.cqse.check.cpp.misra.arrays.EArrayType;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ArrayAutomatonContext {
    private static final TokenPattern ARRAY_INITIALIZATION_PATTERN = ArrayAutomatonContext.createArrayInitializationPattern();
    private final int[] dimensions;
    private final int capacity;
    private final int[] dimensionCapacities;
    private final List<IToken> initializationTokens;
    private final EArrayType type;

    private ArrayAutomatonContext(int[] dimensions, List<IToken> initializationTokens, EArrayType type) {
        this.dimensions = dimensions;
        this.initializationTokens = initializationTokens;
        this.type = type;
        this.capacity = this.calculateCapacity();
        this.dimensionCapacities = this.calculateDimensionCapacities();
    }

    private static TokenPattern createArrayInitializationPattern() {
        TokenPattern bracketPattern = new TokenPattern().sequence(new Object[]{ETokenType.LBRACK, ETokenType.INTEGER_LITERAL, ETokenType.RBRACK});
        TokenPattern compoundPattern = new TokenPattern().skipNested((Object)ETokenType.LBRACE, (Object)ETokenType.RBRACE, true);
        TokenPattern stringLiteralPattern = new TokenPattern().repeatedAtLeastOnce(new Object[]{ETokenType.STRING_LITERAL});
        return new TokenPattern().beginningOfStream().skipTo(new Object[]{bracketPattern}).repeated(new Object[]{bracketPattern}).sequence(new Object[]{ETokenType.EQ}).alternative(new Object[]{stringLiteralPattern, compoundPattern}).optional(new Object[]{ETokenType.SEMICOLON}).endOfStream();
    }

    public static Optional<ArrayAutomatonContext> createArrayContext(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        if (!ARRAY_INITIALIZATION_PATTERN.matchesAnywhere((List)tokens)) {
            return Optional.empty();
        }
        int leftBracketIndex = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.LBRACK);
        EArrayType type = EArrayType.getType(tokens.subList(0, leftBracketIndex - 1));
        int eqIndex = TokenStreamUtils.firstTokenMatching(tokens.subList(leftBracketIndex, tokens.size()), (ITokenMatcher)ETokenType.EQ) + leftBracketIndex;
        return ArrayAutomatonContext.extractArrayDimensions(tokens.subList(leftBracketIndex, eqIndex)).map(arg_0 -> ArrayAutomatonContext.lambda$createArrayContext$0((List)tokens, eqIndex, type, arg_0));
    }

    private static Optional<int[]> extractArrayDimensions(List<IToken> dimensionTokens) {
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        StringBuilder dimensionCache = new StringBuilder();
        block4: for (IToken token : dimensionTokens) {
            switch (token.getType()) {
                case LBRACK: {
                    dimensionCache.setLength(0);
                    continue block4;
                }
                case RBRACK: {
                    if (!CppIntegerLiteralParser.isInteger((String)dimensionCache.toString())) {
                        return Optional.empty();
                    }
                    dimensions.add(CppIntegerLiteralParser.parse((String)dimensionCache.toString()));
                    continue block4;
                }
            }
            dimensionCache.append(token.getText());
        }
        return Optional.ofNullable(dimensions.stream().mapToInt(i -> i).toArray());
    }

    private int calculateCapacity() {
        boolean hasOnlyZeroDimensions = true;
        int capacity = 1;
        for (int dimension : this.dimensions) {
            if (dimension == 0) continue;
            hasOnlyZeroDimensions = false;
            capacity *= dimension;
        }
        if (hasOnlyZeroDimensions) {
            return 0;
        }
        return capacity;
    }

    private int[] calculateDimensionCapacities() {
        if (this.dimensionality() == 0) {
            return new int[0];
        }
        int[] dimensionCapacities = new int[this.dimensions.length];
        dimensionCapacities[0] = this.dimensions[0] == 0 ? this.capacity : this.capacity / this.dimensions[0];
        for (int i = 1; i < this.dimensions.length; ++i) {
            dimensionCapacities[i] = this.dimensions[i] == 0 ? dimensionCapacities[i - 1] : dimensionCapacities[i - 1] / this.dimensions[i];
        }
        return dimensionCapacities;
    }

    public int[] toIndexes(int offset) {
        int[] indexes = new int[this.dimensionality()];
        for (int i = 0; i < this.dimensionality(); ++i) {
            if (this.dimensionCapacities[i] == 0) {
                indexes[i] = 0;
                continue;
            }
            indexes[i] = offset / this.dimensionCapacities[i];
            offset -= indexes[i] * this.dimensionCapacities[i];
        }
        return indexes;
    }

    public int toOffset(int[] indexes) {
        int offset = 0;
        for (int i = 0; i < indexes.length; ++i) {
            offset += this.dimensionCapacities[i] * indexes[i];
        }
        return offset;
    }

    public List<IToken> getCompoundTokens(IToken startToken) {
        int startIndex = this.getInitializationTokens().indexOf(startToken);
        int endIndex = TokenStreamUtils.firstTokenMatching(this.getInitializationTokens(), (int)(startIndex + 1), (ITokenMatcher)ETokenType.ETokenClass.DELIMITER.except(new ITokenMatcher[]{ETokenType.COMMA}));
        if (this.getInitializationTokens().get(endIndex - 1).getType() == ETokenType.COMMA) {
            --endIndex;
        }
        return this.getInitializationTokens().subList(startIndex, endIndex);
    }

    public int getDimensionSize(int dimensionIndex) {
        if (dimensionIndex < 0 || this.dimensionality() <= dimensionIndex) {
            return 0;
        }
        return this.dimensions[dimensionIndex];
    }

    public int dimensionality() {
        return this.dimensions.length;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public List<IToken> getInitializationTokens() {
        return this.initializationTokens;
    }

    public EArrayType getType() {
        return this.type;
    }

    private static /* synthetic */ ArrayAutomatonContext lambda$createArrayContext$0(List tokens, int eqIndex, EArrayType type, int[] dimensions) {
        return new ArrayAutomatonContext(dimensions, tokens.subList(eqIndex + 1, tokens.size()), type);
    }
}

