/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.iec61131;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-assert-uppercase-keywords-and-operators", languages={ELanguage.IEC61131}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AssertUppercaseKeywordsAndOperators
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List allEntities = ShallowEntityTraversalUtils.getAllEntities((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()));
        for (ShallowEntity entity : allEntities) {
            this.processTokens((List<IToken>)entity.ownStartTokens());
            this.processTokens((List<IToken>)entity.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) {
        IToken prevToken = null;
        for (IToken token : tokens) {
            if (!token.getType().isKeyword() && !token.getType().isOperator()) {
                prevToken = token;
                continue;
            }
            String text = token.getText().trim();
            if (!AssertUppercaseKeywordsAndOperators.isUpperCase(text)) {
                String prefix = "Keyword";
                if (token.getType().isOperator()) {
                    prefix = "Operator";
                }
                if (prevToken != null && prevToken.getType() == ETokenType.DOT) {
                    prevToken = token;
                    continue;
                }
                this.buildFinding(prefix + " should be written in uppercase (`" + text + "` -> `" + text.toUpperCase() + "`)", this.buildLocation().forToken(token)).createAndStore();
            }
            prevToken = token;
        }
    }

    private static boolean isUpperCase(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        return text.equals(text.toUpperCase());
    }
}

