/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-avoid-volatile-fields", languages={ELanguage.JAVA, ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidVolatileFieldsCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            if (!TokenStreamUtils.contains((List)attribute.ownStartTokens(), (ETokenType)ETokenType.VOLATILE)) continue;
            this.processEntity(attribute);
        }
    }

    private void processEntity(ShallowEntity entity) {
        this.buildFinding("Avoid marking `" + entity.getName() + "` as `volatile`", this.buildLocation().forEntity(entity)).createAndStore();
    }
}

