/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

@Check(id="cqse-order-of-modifiers", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class OrderOfModifiersCheck
extends CheckImplementationBase {
    private static final Map<String, Integer> MODIFIER_ORDER = Map.ofEntries(Map.entry("public", 1), Map.entry("private", 1), Map.entry("protected", 1), Map.entry("abstract", 2), Map.entry("static", 3), Map.entry("default", 3), Map.entry("final", 4), Map.entry("transient", 5), Map.entry("volatile", 6), Map.entry("synchronized", 7), Map.entry("native", 8), Map.entry("strictfp", 9));

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.METHOD, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processEntity(selectedEntity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        int previousPriority = 0;
        for (IToken token : entity.includedTokens()) {
            if (!MODIFIER_ORDER.containsKey(token.getText())) {
                return;
            }
            if (MODIFIER_ORDER.get(token.getText()) < previousPriority) {
                this.buildFinding("Modifiers of `" + entity.getName() + "` are in wrong order", this.buildLocation().forToken(token)).createAndStore();
                return;
            }
            previousPriority = MODIFIER_ORDER.get(token.getText());
        }
    }
}

