/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-package-name", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PackageNameCheck
extends CheckImplementationBase {
    @CheckOption(name="Allowed package prefixes", description="The package prefixes that are allowed to be used.")
    private List<String> allowedPrefixes = new ArrayList<String>();

    public void execute() throws CheckException {
        List topLevelEntities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        for (ShallowEntity topLevelEntity : topLevelEntities) {
            if (topLevelEntity.getType() != EShallowEntityType.META || !topLevelEntity.getSubtype().equals("package")) continue;
            this.processEntity(topLevelEntity);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (!StringUtils.startsWithOneOf((String)entity.getName(), this.allowedPrefixes)) {
            this.buildFinding("Package name '" + entity.getName() + "' does not conform to the guideline. Allowed package prefixes: " + String.valueOf(this.allowedPrefixes), this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

