/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.comment;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.SingleTokenPatternBase;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public enum EJavaDocParameter {
    SINGLE_WORD_PARAMETER("single word"),
    CLASS_REFERENCE_PARAMETER("class reference"),
    TEXT_PARAMETER("text"),
    OPTIONAL_TEXT_PARAMETER("optional text"),
    CODE_PARAMETER("code"),
    REFERENCE_PARAMETER("reference"),
    PARAMETER_PARAMETER("parameter name"),
    OPTIONAL_REFERENCE_PARAMETER("optional reference");

    private static final UnmodifiableSet<ETokenType> TEXT_TOKEN_TYPES;
    private static final UnmodifiableSet<ETokenType> TEXT_TOKEN_TYPES_AND_EOL;
    private static final UnmodifiableSet<ETokenType> CODE_TOKEN_TYPES;
    private static final UnmodifiableSet<ETokenType> CODE_TOKEN_TYPES_AND_EOL;
    public static final UnmodifiableSet<ETokenType> OPENING_TOKEN_TYPES;
    public static final UnmodifiableSet<ETokenType> CLOSING_TOKEN_TYPES;
    private static final TokenPattern NESTED_BRACES;
    private static final TokenPattern BRACES;
    private final String parameterName;

    private EJavaDocParameter(String parameterName) {
        this.parameterName = parameterName;
    }

    public TokenPattern getPattern(ShallowEntity relatedEntity) {
        TokenPattern parameterPattern = new TokenPattern();
        switch (this.ordinal()) {
            case 1: {
                parameterPattern.sequence(new Object[]{EnumSet.of(ETokenType.WORD, ETokenType.NUMBER_WORD, ETokenType.REFERENCE)});
                break;
            }
            case 0: {
                parameterPattern.sequence(new Object[]{EnumSet.of(ETokenType.WORD, ETokenType.NUMBER_WORD)});
                break;
            }
            case 2: 
            case 3: {
                TokenPattern startTextPattern = new TokenPattern().alternative(new Object[]{TEXT_TOKEN_TYPES, NESTED_BRACES, BRACES});
                TokenPattern endTextPattern = new TokenPattern().alternative(new Object[]{TEXT_TOKEN_TYPES_AND_EOL, NESTED_BRACES, BRACES});
                parameterPattern.repeatedAtLeastOnce(new Object[]{startTextPattern}).repeated(new Object[]{endTextPattern});
                break;
            }
            case 4: {
                TokenPattern startCodePattern = new TokenPattern().alternative(new Object[]{CODE_TOKEN_TYPES, NESTED_BRACES, BRACES});
                TokenPattern endCodePattern = new TokenPattern().alternative(new Object[]{CODE_TOKEN_TYPES_AND_EOL, NESTED_BRACES, BRACES});
                parameterPattern.repeatedAtLeastOnce(new Object[]{startCodePattern}).repeated(new Object[]{endCodePattern});
                break;
            }
            case 5: 
            case 7: {
                parameterPattern.sequence(new Object[]{EnumSet.of(ETokenType.WORD, ETokenType.REFERENCE)});
                break;
            }
            case 6: {
                Set<String> parameterNames = EJavaDocParameter.getParameterNames(relatedEntity);
                parameterPattern.optional(new Object[]{EJavaDocParameter.getStringMatcher("<")}).alternative(new Object[]{EJavaDocParameter.getStringMatcher(parameterNames)}).optional(new Object[]{EJavaDocParameter.getStringMatcher(">")});
                break;
            }
        }
        if (this.isOptional()) {
            parameterPattern = new TokenPattern().optional(new Object[]{parameterPattern});
        }
        return parameterPattern;
    }

    public boolean isOptional() {
        return this.name().startsWith("OPTIONAL");
    }

    private static SingleTokenPatternBase getStringMatcher(String string) {
        return EJavaDocParameter.getStringMatcher(CollectionUtils.asHashSet((Object[])new String[]{string}));
    }

    private static SingleTokenPatternBase getStringMatcher(final Set<String> strings) {
        return new SingleTokenPatternBase(){

            public boolean matchesToken(IToken token) {
                return strings.contains(token.getText());
            }

            public String toString() {
                return strings.toString();
            }
        };
    }

    private static Set<String> getParameterNames(ShallowEntity relatedEntity) {
        if (relatedEntity.getType() == EShallowEntityType.METHOD) {
            Set<String> parameterNames = EJavaDocParameter.getNonGenericParameterNames(relatedEntity);
            parameterNames.addAll(new HashSet(LanguageFeatureParser.JAVA.getGenericNamesForMethod(relatedEntity)));
            return parameterNames;
        }
        if (relatedEntity.getType() == EShallowEntityType.TYPE) {
            HashSet<String> genericTypeParameters = new HashSet<String>(LanguageFeatureParser.JAVA.getGenericNamesForType(relatedEntity));
            if (EJavaDocParameter.isRecord(relatedEntity)) {
                genericTypeParameters.addAll(EJavaDocParameter.getNonGenericParameterNames(relatedEntity));
            }
            return genericTypeParameters;
        }
        return CollectionUtils.emptySet();
    }

    public String toString() {
        return "<" + this.parameterName + ">";
    }

    private static boolean isRecord(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.TYPE && entity.getSubtype().equals("record");
    }

    private static Set<String> getNonGenericParameterNames(ShallowEntity entity) {
        return LanguageFeatureParser.JAVA.getParameterTokens(entity).stream().filter(token -> ETokenType.IDENTIFIER == token.getType()).map(IToken::getText).collect(Collectors.toSet());
    }

    static {
        TEXT_TOKEN_TYPES = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.REFERENCE, ETokenType.WORD, ETokenType.NUMBER_WORD, ETokenType.AT));
        TEXT_TOKEN_TYPES_AND_EOL = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.REFERENCE, ETokenType.WORD, ETokenType.NUMBER_WORD, ETokenType.AT, ETokenType.EOL));
        CODE_TOKEN_TYPES = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.REFERENCE, ETokenType.WORD, ETokenType.NUMBER_WORD, ETokenType.AT, ETokenType.JAVADOC_TAG));
        CODE_TOKEN_TYPES_AND_EOL = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.REFERENCE, new ETokenType[]{ETokenType.WORD, ETokenType.NUMBER_WORD, ETokenType.AT, ETokenType.JAVADOC_TAG, ETokenType.EOL}));
        OPENING_TOKEN_TYPES = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.JAVADOC_INLINE_TAG, ETokenType.LBRACE));
        CLOSING_TOKEN_TYPES = CollectionUtils.asUnmodifiable(EnumSet.of(ETokenType.RBRACE));
        NESTED_BRACES = new TokenPattern().skipNested(OPENING_TOKEN_TYPES, CLOSING_TOKEN_TYPES, false);
        BRACES = new TokenPattern().alternative(new Object[]{ETokenType.LBRACE, ETokenType.RBRACE});
    }
}

