/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.concurrency;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.java.concurrency.JavaCriticalSectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-avoid-overlapping-critical-sections", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidOverlappingCriticalSectionsCheck
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Avoid overlapping critical sections";

    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if ("lambda".equals(method.getSubtype())) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity method) {
        ArrayList criticalSections = Lists.newArrayList((Iterable)Iterables.concat(JavaCriticalSectionUtils.getSynchronizedMethodCriticalSections(method), JavaCriticalSectionUtils.getSynchronizedBlockCriticalSections(method), JavaCriticalSectionUtils.getLockUnlockCriticalSections(method)));
        for (int i = 0; i < criticalSections.size(); ++i) {
            for (int j = i + 1; j < criticalSections.size(); ++j) {
                List firstCriticalSection = ((MatchGroupElement)criticalSections.get(i)).getTokens();
                List secondCriticalSection = ((MatchGroupElement)criticalSections.get(j)).getTokens();
                this.checkForOverlap(firstCriticalSection, secondCriticalSection);
            }
        }
    }

    private void checkForOverlap(List<IToken> first, List<IToken> second) {
        int secondEndOffset;
        if (first.isEmpty() || second.isEmpty()) {
            return;
        }
        int firstStartOffset = AvoidOverlappingCriticalSectionsCheck.getStartToken(first).getOffset();
        if (firstStartOffset > (secondEndOffset = AvoidOverlappingCriticalSectionsCheck.getEndToken(second).getEndOffset())) {
            return;
        }
        int firstEndOffset = AvoidOverlappingCriticalSectionsCheck.getEndToken(first).getEndOffset();
        int secondStartOffset = AvoidOverlappingCriticalSectionsCheck.getStartToken(second).getOffset();
        if (secondStartOffset > firstEndOffset) {
            return;
        }
        int overlapStartOffset = Math.max(firstStartOffset, secondStartOffset);
        int overlapEndOffset = Math.min(firstEndOffset, secondEndOffset);
        this.buildFinding(CHECK_NAME, this.buildLocation().betweenOffsets(overlapStartOffset, overlapEndOffset)).createAndStore();
    }

    private static IToken getStartToken(List<IToken> first) {
        return first.get(0);
    }

    private static IToken getEndToken(List<IToken> first) {
        return first.get(first.size() - 1);
    }
}

