/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.xml;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.java.xml.XMLCheckUtils;
import eu.cqse.check.java.xml.XMLFeatures;
import eu.cqse.check.java.xml.XMLPatternMatcher;
import eu.cqse.check.java.xml.XMLType;
import eu.cqse.check.java.xml.XMLTypeInformation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.lib.commons.collections.SetMap;

@Check(id="java:S6377", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class XMLValidatedSignatureCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        this.analyzeStatements(statements);
    }

    private void analyzeStatements(List<ShallowEntity> statements) throws CheckException {
        ITypeResolution lookup = this.context.getTypeResolution(this.getCodeViewOption());
        SetMap<ShallowEntity, XMLTypeInformation> xmlTypeInformation = XMLCheckUtils.extractXMLTypeInformation(statements, lookup);
        Set<ShallowEntity> problematicEntities = XMLValidatedSignatureCheck.getProblematicEntities(xmlTypeInformation);
        for (ShallowEntity statement : problematicEntities) {
            this.buildFinding("Enable secure XML signature validation", this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private static Set<ShallowEntity> getProblematicEntities(SetMap<ShallowEntity, XMLTypeInformation> helpers) {
        Predicate<ShallowEntity> predicate = entity -> {
            Set typeInfos = (Set)helpers.getCollectionOrEmpty(entity);
            return typeInfos.stream().anyMatch(helper -> XMLValidatedSignatureCheck.secureValidationIsDisabled(entity, helper.variable(), helper.xmlType()));
        };
        return new HashSet<ShallowEntity>(ShallowEntityTraversalUtils.selectEntities((Collection)helpers.getKeys(), predicate));
    }

    private static boolean secureValidationIsDisabled(ShallowEntity statement, String variable, XMLType xmlParserType) {
        if (xmlParserType.hasFeature(XMLFeatures.SIGNATURE_VALIDATION)) {
            XMLPatternMatcher matcher = new XMLPatternMatcher(variable, (List<IToken>)statement.ownStartTokens());
            matcher.addPropertyPattern("org.jcp.xml.dsig.secureValidation", false);
            return matcher.hasMatch();
        }
        return false;
    }
}

