/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableListIterator;

@Check(id="cqse-no-eval", languages={ELanguage.MATLAB}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoEval
extends CheckImplementationBase {
    private static final String CHECK_NAME = "Avoid use of eval when possible";

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableListIterator it = entity.ownStartTokens().listIterator();
        while (it.hasNext()) {
            IToken token = (IToken)it.next();
            boolean isEvalIdentifier = token.getType() == ETokenType.IDENTIFIER && token.getText().equals("eval");
            if (!isEvalIdentifier) continue;
            if (!it.hasNext()) {
                return;
            }
            IToken nextToken = (IToken)it.next();
            if (nextToken.getType() != ETokenType.LPAREN) continue;
            this.buildFinding(CHECK_NAME, this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

