/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.objc;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-objc-inconsistent-extension", languages={ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, groupName="Naming")
public class ObjCInconsistentExtensionCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "%s source files and headers should use file extensions specific to %s: %s";
    @CheckOption(name="Expected Objective-C File Extensions", description="Extensions that every file containing Objective-C code is expected to have")
    private Set<String> objcExpectedExtensions = Set.of("h", "m");
    private final Set<String> objCppExpectedExtensions = Set.of("h", "mm");

    public void execute() throws CheckException {
        Set<String> expectedExtensions = this.context.getLanguage() == ELanguage.OBJECTIVE_C ? this.objcExpectedExtensions : this.objCppExpectedExtensions;
        String expectedLanguage = this.context.getLanguage() == ELanguage.OBJECTIVE_C ? "Objective-C" : "Objective-CPP";
        String fileExtension = FileSystemUtils.getFileExtension((String)this.context.getUniformPath());
        if (fileExtension == null || !expectedExtensions.contains(fileExtension)) {
            String sortedExtensionsString = StringUtils.concat(expectedExtensions.stream().sorted().toList(), (String)", ");
            this.buildFinding(String.format(FINDING_MESSAGE, expectedLanguage, expectedLanguage, sortedExtensionsString), this.buildLocation().forElement()).createAndStore();
        }
    }
}

