/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;

@Check(id="cqse.jmaab.jc_0700", languages={ELanguage.SIMULINK})
public class SimulinkUnusedDataInStateflowCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION_SET_WARNING_OR_ERROR = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the configuration parameter `Unused data, events, messages, and functions` to `Warning` or `Error`.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        String mode = model.getParameter("SFUnusedDataAndEventsDiag");
        if (mode != null && mode.equals("none")) {
            this.buildFinding("Configuration parameter `Unused data, events, messages, and functions` is set to `none`", (ElementLocation)this.buildLocation().forSimulinkBlock((SimulinkBlock)model)).addFindingProperties(RECOMMENDED_ACTION_SET_WARNING_OR_ERROR).createAndStore();
        }
    }
}

