/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.simulink.naming_conventions.SimulinkNameLengthCheckUtils;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.util.Comparator;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0796", languages={ELanguage.SIMULINK})
public class SimulinkStateflowDataNameLengthCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum length of Stateflow data names", description="The maximum number of characters for names of stateflow data.")
    private int maximumLength = 60;

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (StateflowBlock stateflowBlock : StateflowUtils.listStateflowBlocksDepthFirst((SimulinkBlock)model)) {
            if (StateflowUtils.isMatlabFunctionBlock((SimulinkBlock)stateflowBlock)) continue;
            StateflowChart chart = stateflowBlock.getChart();
            List stateflowNodes = StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false);
            this.checkDataNamesInStates(stateflowNodes);
            List dataNames = StateflowUtils.extractDataNames((UnmodifiableSet)chart.getData());
            dataNames.sort(Comparator.reverseOrder());
            for (String dataName : dataNames) {
                if (this.checkUsageOfChartDataNameInStates(dataName, stateflowNodes) || this.checkUsageOfChartDataNameInTransitions(dataName, StateflowUtils.getAllTransitions((StateflowChart)chart, (boolean)false))) continue;
                this.checkUnusedChartDataName(stateflowBlock, dataName);
            }
        }
    }

    private void checkDataNamesInStates(List<StateflowNodeBase> stateflowNodes) {
        for (StateflowNodeBase stateflowNode : stateflowNodes) {
            for (String dataName : StateflowUtils.extractDataNames((UnmodifiableSet)stateflowNode.getData())) {
                SimulinkNameLengthCheckUtils.performLengthRestrictionCheck(this.context, 0, this.maximumLength, dataName, "Data", this.buildLocation().forStateflowNode(stateflowNode));
            }
        }
    }

    private void checkUnusedChartDataName(StateflowBlock stateflowBlock, String dataName) {
        SimulinkNameLengthCheckUtils.performLengthRestrictionCheck(this.context, 0, this.maximumLength, dataName, "Data", this.buildLocation().forSimulinkBlock((SimulinkBlock)stateflowBlock));
    }

    private boolean checkUsageOfChartDataNameInTransitions(String dataName, List<StateflowTransition> transitions) {
        for (StateflowTransition transition : transitions) {
            if (!SimulinkStateflowDataNameLengthCheck.dataNameIsUsedInTransition(transition, dataName)) continue;
            SimulinkNameLengthCheckUtils.performLengthRestrictionCheck(this.context, 0, this.maximumLength, dataName, "Data", this.buildLocation().forStateflowTransition(transition));
            return true;
        }
        return false;
    }

    private static boolean dataNameIsUsedInTransition(StateflowTransition transition, String dataName) {
        if (StringUtils.isEmpty((String)transition.getLabel())) {
            return false;
        }
        StateflowTransitionParts stateflowTransitionParts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
        return SimulinkStateflowDataNameLengthCheck.dataNameIsUsedInScript(dataName, stateflowTransitionParts.eventOrMessage) || SimulinkStateflowDataNameLengthCheck.dataNameIsUsedInScript(dataName, stateflowTransitionParts.condition) || SimulinkStateflowDataNameLengthCheck.dataNameIsUsedInScript(dataName, stateflowTransitionParts.conditionAction) || SimulinkStateflowDataNameLengthCheck.dataNameIsUsedInScript(dataName, stateflowTransitionParts.transitionAction);
    }

    private boolean checkUsageOfChartDataNameInStates(String dataName, List<StateflowNodeBase> stateflowNodes) {
        for (StateflowNodeBase stateflowNode : stateflowNodes) {
            if (!(stateflowNode instanceof StateflowState)) continue;
            List stateflowStateActions = StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)((StateflowState)stateflowNode));
            String stateEMLScript = stateflowNode.getParameter("eml.script");
            if (!SimulinkStateflowDataNameLengthCheck.dataNameIsUsedInStateLabel(dataName, stateflowStateActions) && !this.dataNameIsUsedInEMLScript(dataName, stateEMLScript)) continue;
            SimulinkNameLengthCheckUtils.performLengthRestrictionCheck(this.context, 0, this.maximumLength, dataName, "Data", this.buildLocation().forStateflowNode(stateflowNode));
            return true;
        }
        return false;
    }

    private static boolean dataNameIsUsedInStateLabel(String dataName, List<StateflowStateAction> stateflowStateActions) {
        for (StateflowStateAction stateflowStateAction : stateflowStateActions) {
            if (!SimulinkStateflowDataNameLengthCheck.dataNameIsUsedInScript(dataName, stateflowStateAction.actionCode)) continue;
            return true;
        }
        return false;
    }

    private boolean dataNameIsUsedInEMLScript(String dataName, String script) {
        if (StringUtils.isEmpty((String)script)) {
            return false;
        }
        return SimulinkStateflowDataNameLengthCheck.dataNameIsUsedInScript(dataName, ScannerUtils.getTokens((String)script, (ELanguage)ELanguage.MATLAB, (String)this.context.getUniformPath()));
    }

    private static boolean dataNameIsUsedInScript(String dataName, List<IToken> tokens) {
        List identifierTokens = TokenStreamUtils.findAllTokens(tokens, (ITokenMatcher)ETokenType.IDENTIFIER);
        return identifierTokens.stream().anyMatch(token -> token.getText().equals(dataName));
    }
}

