/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.db_0143", languages={ELanguage.SIMULINK})
public class SimulinkMixingBasicBlocksAndSubsystemsCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Refactor levels of models containing both subsystems and basic blocks by inlining or creating further subsystems");
    private static final String FINDING_MESSAGE = "Basic block type {0} on the same level as subsystem(s)";
    private static final Set<String> DEFAULT_ALLOWED_BLOCKS = CollectionUtils.asHashSet((Object[])new String[]{"ActionPort", "BusCreator", "BusSelector", "SwitchCase", "DataStoreMemory", "DataTypeConversion", "Demux", "EnablePort", "From", "Function-Call Generator", "FunctionCallSplit", "Goto", "If", "Inport", "InportShadow", "Merge", "Mux", "Outport", "RateTransition", "Selector", "Ground", "Terminator", "TriggerPort", "UnitDelay"});
    @CheckOption(name="Allowed Block Types on Root Level", description="These block types are allowed on root level. See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private Set<String> allowedBlockTypesOnRootLevel = DEFAULT_ALLOWED_BLOCKS;
    @CheckOption(name="Allowed Block Types on Top Level", description="These block types are allowed on top level. This is the level below the root level See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private Set<String> allowedBlockTypesOnTopLevel = DEFAULT_ALLOWED_BLOCKS;
    private final Map<ELevel, Set<String>> allowedBlocks = new HashMap<ELevel, Set<String>>();

    public void initialize() {
        this.allowedBlocks.put(ELevel.ROOT, this.allowedBlockTypesOnRootLevel);
        this.allowedBlocks.put(ELevel.TOP, this.allowedBlockTypesOnTopLevel);
    }

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        this.checkForMixedBlockTypesRecursive((SimulinkBlock)model, ELevel.ROOT);
    }

    private void checkForMixedBlockTypesRecursive(SimulinkBlock system, ELevel level) {
        boolean hasSubSystem = false;
        ArrayList<SimulinkBlock> basicBlocks = new ArrayList<SimulinkBlock>();
        for (SimulinkBlock block2 : system.getSubBlocks()) {
            if (this.isAllowedBlockForLevel(block2, level) || SimulinkUtils.isCommentedBlock((SimulinkBlock)block2) || !SimulinkUtils.isUserVisible((SimulinkBlock)block2)) continue;
            if (SimulinkMixingBasicBlocksAndSubsystemsCheck.isBasicBlock(block2)) {
                basicBlocks.add(block2);
                continue;
            }
            if (!SimulinkUtils.isMaskedSubsystem((SimulinkBlock)block2)) {
                hasSubSystem = true;
            }
            if (level != ELevel.ROOT) continue;
            this.checkForMixedBlockTypesRecursive(block2, ELevel.TOP);
        }
        if (hasSubSystem) {
            basicBlocks.forEach(block -> this.buildFinding(MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)block.getNamePretty())), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore());
        }
    }

    private static boolean isBasicBlock(SimulinkBlock block) {
        return !block.isOfType("SubSystem") && !block.isOfSourceType("SubSystem") && !block.isOfType("ModelReference");
    }

    private boolean isAllowedBlockForLevel(SimulinkBlock block, ELevel level) {
        String type = block.getType();
        if ("Reference".equals(type)) {
            type = block.getSourceType();
        }
        return this.allowedBlocks.get((Object)level).contains(type);
    }

    private static enum ELevel {
        ROOT,
        TOP;

    }
}

