/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0001", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfAbsBlockCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_INVALID_TYPE = "Abs block uses boolean or unsigned data type as input";
    private static final String FINDING_MESSAGE_INVALID_PARAMETER = "Abs block has not set the Block Parameter 'Saturate on integer overflow'";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the input of the Abs block to a a signed and non-boolean data type, and select the Block Parameter 'Saturate on integer overflow'.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        SimulinkResolvedDataTypes resolvedTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (model == null || resolvedTypes == null) {
            return;
        }
        List absBlocks = SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("Abs"), (boolean)false, (boolean)false);
        for (SimulinkBlock block : absBlocks) {
            this.checkBlock(resolvedTypes, block);
        }
    }

    private void checkBlock(SimulinkResolvedDataTypes resolvedTypes, SimulinkBlock block) {
        if (SimulinkUsageOfAbsBlockCheck.hasBooleanOrUnsignedDatatype(block, resolvedTypes)) {
            this.buildFinding(FINDING_MESSAGE_INVALID_TYPE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
        if (SimulinkUsageOfAbsBlockCheck.hasSaturateParameterDisabled(block)) {
            this.buildFinding(FINDING_MESSAGE_INVALID_PARAMETER, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean hasBooleanOrUnsignedDatatype(SimulinkBlock absBlock, SimulinkResolvedDataTypes resolvedTypes) {
        String inputDataType = resolvedTypes.getInputDataType(absBlock, "1");
        if (inputDataType == null) {
            return false;
        }
        return "boolean".equals(inputDataType) || SimulinkDataTypeUtils.isUnsignedIntDataType((String)inputDataType);
    }

    private static boolean hasSaturateParameterDisabled(SimulinkBlock absBlock) {
        String saturateParameter = absBlock.getParameter("SaturateOnIntegerOverflow");
        return "off".equals(saturateParameter);
    }
}

