/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0033", languages={ELanguage.SIMULINK})
public class SimulinkUsageOfLookupTableBlocksCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION_LOOKUP_BLOCKS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Clear block parameter `Remove protection against out-of-range input in generated code`.");
    private static final FindingPropertyList RECOMMENDED_ACTION_INTERPOLATION_BLOCKS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Clear block parameter `Remove protection against out-of-range index in generated code`.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("Lookup_n-D", "PreLookup"), (boolean)false, (boolean)false).forEach(this::checkLookupBlock);
        SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("Interpolation_n-D"), (boolean)false, (boolean)false).forEach(this::checkInterpolationBlock);
    }

    private void checkLookupBlock(SimulinkBlock block) {
        String paramRemoveProtectionInput = block.getParameter("RemoveProtectionInput");
        if ("on".equals(paramRemoveProtectionInput)) {
            this.buildFinding("Block of type " + block.getType() + " has set parameter 'Remove protection against out-of-range input in generated code' to 'on'", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_LOOKUP_BLOCKS).createAndStore();
        }
    }

    public void checkInterpolationBlock(SimulinkBlock block) {
        String paramRemoveProtectionIndex = block.getParameter("RemoveProtectionIndex");
        if ("on".equals(paramRemoveProtectionIndex)) {
            this.buildFinding("Block of type " + block.getType() + " has set parameter 'Remove protection against out-of-range index in generated code' to 'on'", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_INTERPOLATION_BLOCKS).createAndStore();
        }
    }
}

