/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink.phases;

import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.simulink.utils.SimulinkPhaseUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.test.IndexValueClass;

public class SimulinkModelBlockIdListingPhase
implements IGlobalExtractionPhase<BlockIdDefinition, String> {
    public boolean needsAccessByValue() {
        return true;
    }

    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.SIMULINK);
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.RUN_ON_HIDDEN_ELEMENTS);
    }

    public List<BlockIdDefinition> extract(ITokenElementContext fileContext) {
        Optional model = fileContext.getSimulinkContext().getSimulinkModelForModelFile();
        return model.map(SimulinkPhaseUtils::getBlockIdDefinitions).orElse(Collections.emptyList());
    }

    public BlockIdDefinition createValue(String uniformPath, String value, String additionalInformation) {
        return new BlockIdDefinition(uniformPath, value);
    }

    @IndexValueClass
    public static class BlockIdDefinition
    implements IExtractedValue<String> {
        public final String uniformPath;
        private final String blockId;

        public BlockIdDefinition(String uniformPath, String blockId) {
            this.uniformPath = uniformPath;
            this.blockId = blockId;
        }

        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return this.blockId;
        }

        public String getAdditionalInformation() {
            return "";
        }
    }
}

