/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.accounts;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsProviderRegistry;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.optional.OptionalWithException;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="external-credentials", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP, EStorageOption.ENCRYPTED})
public class ExternalCredentialsIndex
implements IGlobalIndex,
IExternalCredentialsProvider {
    public static final String INDEX_NAME = "external-credentials";
    private final ValueIndex<ExternalCredentials> delegate;

    public ExternalCredentialsIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void setExternalCredentials(ExternalCredentials externalCredentials) throws StorageException {
        this.delegate.setValue(externalCredentials.credentialsName, (Object)externalCredentials);
    }

    @Override
    public @Nullable ExternalCredentials getExternalCredentials(String credentialsName) throws StorageException {
        return (ExternalCredentials)OptionalWithException.wrap(ExternalCredentialsIndex.readCredentialsFromRegisteredProviders(credentialsName)).orElseGet(() -> (ExternalCredentials)this.delegate.getValue(credentialsName));
    }

    private static Optional<ExternalCredentials> readCredentialsFromRegisteredProviders(String credentialsName) throws StorageException {
        return IStreamWithException.wrap((Stream)ExternalCredentialsProviderRegistry.getInstance().getProviders().stream()).withException(StorageException.class).map(provider -> provider.getExternalCredentials(credentialsName)).filter(Objects::nonNull).findAny();
    }

    public void deleteExternalCredentials(ExternalCredentials externalCredentials) throws StorageException {
        this.delegate.removeValue(externalCredentials.credentialsName);
    }

    public List<ExternalCredentials> getAllExternalCredentials() throws StorageException {
        return this.delegate.getAllEntries().extractSecondList();
    }
}

