/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.google;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.AiEngineProviderOptionBase;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.ai.LlmPrompt;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.MultilineOption;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import java.io.IOException;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public abstract class GoogleAiEngineProviderOptionBase
extends AiEngineProviderOptionBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="project")
    @OptionFieldDescription(name="The name of the GCP project used for billing. The project also needs the Vertex AI API enabled. To enable, visit https://console.cloud.google.com/apis/library/aiplatform.googleapis.com")
    public String project;
    @JsonProperty(value="location")
    @OptionFieldDescription(name="The name of the GCP location used to execute the model.")
    public String location;
    @JsonProperty(value="model")
    @OptionFieldDescription(name="The name of the model to use, such as 'text-bison' or 'gemini-pro'")
    public String model;
    @JsonProperty(value="serviceAccount")
    @MultilineOption
    @PasswordOption
    @OptionFieldDescription(name="The JSON description of the GCP service account to use. Leave empty to use the default service account, which is defined by either environment variables or the GCP machine that Teamscale runs on. The service account needs the permissions 'aiplatform.models.get' and 'aiplatform.endpoints.predict', which are for example provided by the role 'roles/aiplatform.user' (but we recommend to create a custom role).")
    public String serviceAccount;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        try {
            this.createCompleter(null).orElseThrow(() -> new AssertionError((Object)"Unexpectedly no completer was returned")).complete(new LlmPrompt("Hi", new String[0]));
        }
        catch (ServiceCallException e) {
            return e.getMessage();
        }
        return null;
    }

    @Override
    public Optional<ILlmCompleter> createCompleter(@Nullable BiConsumer<String, Long> usageReporter) throws ServiceCallException {
        try {
            return Optional.of(this.createCompleterWithIOException(usageReporter));
        }
        catch (IOException e) {
            throw new ServiceCallException((Throwable)e);
        }
    }

    protected abstract ILlmCompleter createCompleterWithIOException(@Nullable BiConsumer<String, Long> var1) throws IOException;
}

