/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.teamscale.core.analysis.configuration.CodeScopeValidationViolation;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class CodeScopedAnalysisConfigurationValidator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CodeScopeAware<ConfigurationTemplate> configurationTemplatePerCodeScope;
    private final Map<String, CodeScopeValidationViolation> codeScopeValidationViolations;
    private final CodeScopeAware<AnalysisProfile> analysisProfilePerCodeScope;

    public CodeScopedAnalysisConfigurationValidator(CodeScopeAware<ConfigurationTemplate> configurationTemplatePerCodeScope, CodeScopeAware<AnalysisProfile> analysisProfilePerCodeScope) {
        this.configurationTemplatePerCodeScope = configurationTemplatePerCodeScope;
        this.codeScopeValidationViolations = new HashMap<String, CodeScopeValidationViolation>();
        this.analysisProfilePerCodeScope = analysisProfilePerCodeScope;
    }

    public void validate() throws ProjectConfigurationException {
        if (this.analysisProfilePerCodeScope.parameter().size() <= 1) {
            return;
        }
        this.validateGlobalOptions(this.configurationTemplatePerCodeScope);
        this.validateAnalysisGroupOptions(this.configurationTemplatePerCodeScope);
        if (!this.codeScopeValidationViolations.isEmpty()) {
            throw new ProjectConfigurationException("Inconsistencies for code scopes detected: " + String.valueOf(this.codeScopeValidationViolations.values()), this.codeScopeValidationViolations.values());
        }
    }

    private void validateGlobalOptions(CodeScopeAware<ConfigurationTemplate> configurationTemplatePerCodeScope) throws ProjectConfigurationException {
        CodeScopeAware<List> globalOptionsPerCodeScope = configurationTemplatePerCodeScope.map(ConfigurationTemplate::getGlobalOptions);
        List<CodeScopeName> codeScopeNames = globalOptionsPerCodeScope.getCodeScopeNames();
        for (int i = 0; i < codeScopeNames.size() - 1; ++i) {
            CodeScopeName codeScopeNameA = codeScopeNames.get(i);
            CodeScopeName codeScopeNameB = codeScopeNames.get(i + 1);
            ConfigurationTemplate configurationTemplateA = configurationTemplatePerCodeScope.getValue(codeScopeNameA);
            ConfigurationTemplate configurationTemplateB = configurationTemplatePerCodeScope.getValue(codeScopeNameB);
            AnalysisProfile analysisProfileA = this.analysisProfilePerCodeScope.getValue(codeScopeNameA);
            AnalysisProfile analysisProfileB = this.analysisProfilePerCodeScope.getValue(codeScopeNameB);
            HashSet globalOptionNames = CollectionUtils.unionSet(globalOptionsPerCodeScope.getValue(codeScopeNameA).stream().map(ConfigurationItemBase::getName).toList(), (Collection[])new Collection[]{globalOptionsPerCodeScope.getValue(codeScopeNameB).stream().map(ConfigurationItemBase::getName).toList()});
            for (String optionName : globalOptionNames) {
                ConfigOptionDescriptorBase globalOptionA = configurationTemplateA.getGlobalOption(optionName);
                ConfigOptionDescriptorBase globalOptionB = configurationTemplateB.getGlobalOption(optionName);
                String optionValueA = analysisProfileA.getOptionValue(optionName);
                String optionValueB = analysisProfileB.getOptionValue(optionName);
                this.validateConfigurationItem(globalOptionA, optionValueA, globalOptionB, optionValueB, null);
            }
        }
    }

    private void validateAnalysisGroupOptions(CodeScopeAware<ConfigurationTemplate> configurationTemplatePerCodeScope) throws ProjectConfigurationException {
        List<CodeScopeName> codeScopeNames = configurationTemplatePerCodeScope.getCodeScopeNames();
        for (int i = 0; i < codeScopeNames.size(); ++i) {
            for (int j = i + 1; j < codeScopeNames.size(); ++j) {
                CodeScopeName codeScopeNameA = codeScopeNames.get(i);
                CodeScopeName codeScopeNameB = codeScopeNames.get(j);
                ConfigurationTemplate configurationTemplateA = configurationTemplatePerCodeScope.getValue(codeScopeNameA);
                ConfigurationTemplate configurationTemplateB = configurationTemplatePerCodeScope.getValue(codeScopeNameB);
                AnalysisProfile analysisProfileA = this.analysisProfilePerCodeScope.getValue(codeScopeNameA);
                AnalysisProfile analysisProfileB = this.analysisProfilePerCodeScope.getValue(codeScopeNameB);
                Map<String, Map<String, String>> groupToOptionsMappingA = analysisProfileA.getGroupToOptionsMapping();
                Map<String, Map<String, String>> groupToOptionsMappingB = analysisProfileB.getGroupToOptionsMapping();
                HashSet analysisGroupNames = CollectionUtils.unionSet(groupToOptionsMappingA.keySet(), (Collection[])new Collection[]{groupToOptionsMappingB.keySet()});
                for (String analysisGroupName : analysisGroupNames) {
                    this.validateAnalysisGroupOption(analysisGroupName, groupToOptionsMappingA, groupToOptionsMappingB, configurationTemplateA, configurationTemplateB, analysisProfileA.getLanguages(), analysisProfileB.getLanguages(), codeScopeNameA, codeScopeNameB);
                }
            }
        }
    }

    private void validateAnalysisGroupOption(String analysisGroupName, Map<String, Map<String, String>> groupToOptionsMappingA, Map<String, Map<String, String>> groupToOptionsMappingB, ConfigurationTemplate configurationTemplateA, ConfigurationTemplate configurationTemplateB, UnmodifiableSet<ELanguage> languagesA, UnmodifiableSet<ELanguage> languagesB, CodeScopeName codeScopeNameA, CodeScopeName codeScopeNameB) throws ProjectConfigurationException {
        Map<String, String> optionValueByNameA = groupToOptionsMappingA.get(analysisGroupName);
        Map<String, String> optionValueByNameB = groupToOptionsMappingB.get(analysisGroupName);
        HashSet<String> optionNamesForGroup = new HashSet<String>();
        if (optionValueByNameA != null) {
            optionNamesForGroup.addAll(optionValueByNameA.keySet());
        }
        if (optionValueByNameB != null) {
            optionNamesForGroup.addAll(optionValueByNameB.keySet());
        }
        AnalysisGroupDescriptor analysisGroupDescriptorA = configurationTemplateA.getAnalysisGroup(analysisGroupName);
        AnalysisGroupDescriptor analysisGroupDescriptorB = configurationTemplateB.getAnalysisGroup(analysisGroupName);
        HashSet<String> skippableOptions = new HashSet<String>();
        PairList configOptions = new PairList();
        for (String optionName : optionNamesForGroup) {
            ConfigurationItemBase optionDescriptorA = null;
            if (analysisGroupDescriptorA != null) {
                optionDescriptorA = analysisGroupDescriptorA.getConfigurationItem(optionName);
            }
            ConfigurationItemBase optionDescriptorB = null;
            if (analysisGroupDescriptorB != null) {
                optionDescriptorB = analysisGroupDescriptorB.getConfigurationItem(optionName);
            }
            if (optionDescriptorA == null && optionDescriptorB == null) continue;
            ConfigurationItemBase configItem = (ConfigurationItemBase)ObjectUtils.firstNonNull((Object[])new ConfigurationItemBase[]{optionDescriptorA, optionDescriptorB});
            if (configItem instanceof ConfigOptionDescriptorBase) {
                configOptions.add((Object)((ConfigOptionDescriptorBase)optionDescriptorA), (Object)((ConfigOptionDescriptorBase)optionDescriptorB));
                continue;
            }
            if (CodeScopedAnalysisConfigurationValidator.canSkipAnalysisGroupOptionPair(languagesA, languagesB, optionDescriptorA, optionDescriptorB, codeScopeNameA, codeScopeNameB)) {
                skippableOptions.addAll(CodeScopedAnalysisConfigurationValidator.getSkippableOptions(configItem));
                continue;
            }
            String optionValueA = optionValueByNameA == null ? null : optionValueByNameA.get(optionName);
            String optionValueB = optionValueByNameB == null ? null : optionValueByNameB.get(optionName);
            this.validateConfigurationItem(optionDescriptorA, optionValueA, optionDescriptorB, optionValueB, analysisGroupName);
        }
        this.validateConfigurationOptions(analysisGroupName, (PairList<ConfigOptionDescriptorBase, ConfigOptionDescriptorBase>)configOptions, skippableOptions, optionValueByNameA, optionValueByNameB);
    }

    private static Set<String> getSkippableOptions(ConfigurationItemBase configItem) {
        if (!configItem.codeScopeAware()) {
            UnmodifiableList<ConfigOptionDescriptorBase> visibleOptions = configItem.getConfiguration().getVisibleOptions();
            return visibleOptions.stream().filter(c -> !c.codeScopeAware()).map(ConfigurationItemBase::getName).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private void validateConfigurationOptions(String analysisGroupName, PairList<ConfigOptionDescriptorBase, ConfigOptionDescriptorBase> configOptions, Set<String> skippableOptions, Map<String, String> optionValueByNameA, Map<String, String> optionValueByNameB) throws ProjectConfigurationException {
        HashSet<String> skippedOptionNames = new HashSet<String>();
        for (Pair configPair : configOptions) {
            ConfigOptionDescriptorBase configItem = (ConfigOptionDescriptorBase)ObjectUtils.firstNonNull((Object[])new ConfigOptionDescriptorBase[]{(ConfigOptionDescriptorBase)configPair.getFirst(), (ConfigOptionDescriptorBase)configPair.getSecond()});
            String optionName = configItem.getName();
            if (skippableOptions.contains(optionName)) {
                skippedOptionNames.add(optionName);
                continue;
            }
            String optionValueA = optionValueByNameA == null ? null : optionValueByNameA.get(optionName);
            String optionValueB = optionValueByNameB == null ? null : optionValueByNameB.get(optionName);
            this.validateConfigurationItem((ConfigurationItemBase)configPair.getFirst(), optionValueA, (ConfigurationItemBase)configPair.getSecond(), optionValueB, analysisGroupName);
        }
        if (!skippedOptionNames.isEmpty()) {
            LOGGER.warn("The following configuration options have been skipped during code scope validation as Teamscale cannot check them automatically: {}. Please report them in case of unexpected analysis results.", (Object)String.join((CharSequence)", ", skippedOptionNames));
        }
    }

    private static boolean canSkipAnalysisGroupOptionPair(UnmodifiableSet<ELanguage> languagesA, UnmodifiableSet<ELanguage> languagesB, ConfigurationItemBase optionDescriptorA, ConfigurationItemBase optionDescriptorB, CodeScopeName codeScopeNameA, CodeScopeName codeScopeNameB) {
        boolean optionBisUnsupportedForCodeScopeA;
        boolean optionAisUnsupportedForCodeScopeB;
        boolean bl = optionAisUnsupportedForCodeScopeB = optionDescriptorB == null && CodeScopedAnalysisConfigurationValidator.findingDescriptorNotApplicable(optionDescriptorA, languagesB);
        if (CodeScopeName.DEFAULT.equals((Object)codeScopeNameA)) {
            return optionAisUnsupportedForCodeScopeB;
        }
        boolean bl2 = optionBisUnsupportedForCodeScopeA = optionDescriptorA == null && CodeScopedAnalysisConfigurationValidator.findingDescriptorNotApplicable(optionDescriptorB, languagesA);
        if (CodeScopeName.DEFAULT.equals((Object)codeScopeNameB)) {
            return optionBisUnsupportedForCodeScopeA;
        }
        return optionAisUnsupportedForCodeScopeB || optionBisUnsupportedForCodeScopeA;
    }

    private static boolean findingDescriptorNotApplicable(@Nullable ConfigurationItemBase option, Collection<ELanguage> languagesB) {
        if (option == null) {
            return true;
        }
        if (option instanceof FindingDescriptor) {
            FindingDescriptor findingDescriptor = (FindingDescriptor)option;
            return Collections.disjoint(languagesB, findingDescriptor.getLanguages());
        }
        return false;
    }

    private void validateConfigurationItem(@Nullable ConfigurationItemBase configurationA, @Nullable String configurationValueA, @Nullable ConfigurationItemBase configurationB, @Nullable String configurationValueB, @Nullable String analysisGroupName) throws ProjectConfigurationException {
        if (configurationValueA == null && configurationValueB == null) {
            return;
        }
        if (configurationValueB == null) {
            CCSMAssert.isNotNull((Object)configurationA);
            if (!configurationA.codeScopeAware() && CodeScopedAnalysisConfigurationValidator.deviatesFromDefault(configurationA, configurationValueA)) {
                this.addViolation(configurationA, analysisGroupName);
            }
            return;
        }
        if (configurationValueA == null) {
            CCSMAssert.isNotNull((Object)configurationB);
            if (!configurationB.codeScopeAware() && CodeScopedAnalysisConfigurationValidator.deviatesFromDefault(configurationB, configurationValueB)) {
                this.addViolation(configurationB, analysisGroupName);
            }
            return;
        }
        CCSMAssert.isNotNull((Object)configurationA);
        CCSMAssert.isNotNull((Object)configurationB);
        if (!(configurationA.normalizeValue(configurationValueA).equals(configurationB.normalizeValue(configurationValueB)) || configurationA.codeScopeAware() && configurationB.codeScopeAware())) {
            this.addViolation(configurationA, analysisGroupName);
        }
    }

    private void addViolation(ConfigurationItemBase configItem, @Nullable String analysisGroupName) throws ProjectConfigurationException {
        if (analysisGroupName == null) {
            this.addViolationForGlobalOption(configItem);
        } else {
            this.addViolationForGroupConfiguration(configItem, analysisGroupName);
        }
    }

    private void addViolationForGlobalOption(ConfigurationItemBase configOption) throws ProjectConfigurationException {
        HashMap<String, String> valueByProfile = new HashMap<String, String>();
        for (AnalysisProfile analysisProfile : this.analysisProfilePerCodeScope.getValues()) {
            String optionValue = analysisProfile.getOptionValue(configOption.getName());
            if (optionValue != null) {
                optionValue = configOption.normalizeValue(optionValue);
            }
            valueByProfile.put(analysisProfile.getName(), optionValue);
        }
        String valueDescription = "[Advanced Option] " + configOption.getName();
        this.codeScopeValidationViolations.put(valueDescription, new CodeScopeValidationViolation(valueDescription, valueByProfile));
    }

    private void addViolationForGroupConfiguration(ConfigurationItemBase configItem, String analysisGroupName) {
        HashMap<String, String> valueByProfile = new HashMap<String, String>();
        for (AnalysisProfile analysisProfile : this.analysisProfilePerCodeScope.getValues()) {
            AnalysisGroup analysisGroup = analysisProfile.getGroup(analysisGroupName);
            String optionValue1 = "N/A";
            if (analysisGroup != null && analysisGroup.getOptionValue(configItem.getName()) != null) {
                optionValue1 = analysisGroup.getOptionValue(configItem.getName());
            }
            String optionValue = optionValue1;
            valueByProfile.put(analysisProfile.getName(), optionValue);
        }
        String valueDescription = analysisGroupName + "/" + configItem.getName();
        this.codeScopeValidationViolations.put(valueDescription, new CodeScopeValidationViolation(valueDescription, valueByProfile));
    }

    private static boolean deviatesFromDefault(ConfigurationItemBase configurationItem, String optionValue) throws ProjectConfigurationException {
        if (configurationItem instanceof FindingDescriptor) {
            return !optionValue.equals(EFindingEnablement.OFF.name()) && !optionValue.equals(EFindingEnablement.UNDECIDED.name());
        }
        if (configurationItem instanceof ConfigOptionDescriptorBase) {
            ConfigOptionDescriptorBase configOption = (ConfigOptionDescriptorBase)configurationItem;
            return !configurationItem.normalizeValue(optionValue).equals(configurationItem.normalizeValue(configOption.getDefaultValueAsString()));
        }
        if (configurationItem instanceof MetricDescriptor) {
            MetricDescriptor metricDescriptor = (MetricDescriptor)configurationItem;
            return !optionValue.equals(String.valueOf(metricDescriptor.isMetricEnabled()));
        }
        throw new UnsupportedOperationException("checking a deviation from the default is only supported for FindingDescriptor, ConfigOptionDescriptorBase, and MetricDescriptor types");
    }
}

