/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;

public class ConfigurationTemplateManager {
    private static final Comparator<Class<?>> STABLE_CONFIGURATION_CLASS_COMPARATOR = Comparator.comparing(Class::getSimpleName);
    private final Map<Class<? extends AnalysisConfigurationBase>, AnalysisConfigurationBase> allConfigurations = new HashMap<Class<? extends AnalysisConfigurationBase>, AnalysisConfigurationBase>();
    private final CodeScopeAware<ConfigurationTemplate> configurationTemplatePerCodeScope = CodeScopeAware.empty();

    public List<AnalysisConfigurationBase> getExecutedConfigurations(Set<AnalysisConfigurationBase> selectedConfigurations) {
        SetMap requiredClasses = new SetMap();
        for (AnalysisConfigurationBase configuration : selectedConfigurations) {
            if (configuration.isCoreConfiguration()) continue;
            ConfigurationTemplateManager.insertConfigurationToRequired(configuration, (SetMap<Class<? extends AnalysisConfigurationBase>, Class<? extends AnalysisConfigurationBase>>)requiredClasses);
        }
        this.completeRequiredClasses((SetMap<Class<? extends AnalysisConfigurationBase>, Class<? extends AnalysisConfigurationBase>>)requiredClasses);
        List<AnalysisConfigurationBase> executionList = this.obtainOrderedCoreConfigurations();
        executionList.addAll(this.topologicalSortConfigs((SetMap<Class<? extends AnalysisConfigurationBase>, Class<? extends AnalysisConfigurationBase>>)requiredClasses));
        return executionList;
    }

    private void completeRequiredClasses(SetMap<Class<? extends AnalysisConfigurationBase>, Class<? extends AnalysisConfigurationBase>> requiredClasses) {
        int lastSize = 0;
        while (requiredClasses.getKeys().size() > lastSize) {
            lastSize = requiredClasses.getKeys().size();
            for (Class key : new ArrayList(requiredClasses.getKeys())) {
                this.addRequiredClassesForKey(key, requiredClasses);
            }
        }
    }

    private void addRequiredClassesForKey(Class<? extends AnalysisConfigurationBase> key, SetMap<Class<? extends AnalysisConfigurationBase>, Class<? extends AnalysisConfigurationBase>> requiredClasses) {
        AnalysisConfigurationBase configuration = this.allConfigurations.get(key);
        CCSMAssert.isNotNull((Object)configuration, (String)("No configuration '" + String.valueOf(key) + "' registered"));
        for (Class<? extends AnalysisConfigurationBase> required : configuration.getRequiredConfigurations()) {
            AnalysisConfigurationBase requiredConfig = this.allConfigurations.get(required);
            CCSMAssert.isNotNull((Object)requiredConfig, (String)("No configuration '" + String.valueOf(required) + "' registered"));
            if (requiredConfig.isCoreConfiguration()) {
                requiredClasses.remove(key, required);
                continue;
            }
            if (requiredClasses.containsCollection(required)) continue;
            ConfigurationTemplateManager.insertConfigurationToRequired(requiredConfig, requiredClasses);
        }
    }

    private List<AnalysisConfigurationBase> obtainOrderedCoreConfigurations() {
        SetMap requiredClasses = new SetMap();
        for (AnalysisConfigurationBase configuration : this.allConfigurations.values()) {
            if (!configuration.isCoreConfiguration()) continue;
            ConfigurationTemplateManager.insertConfigurationToRequired(configuration, (SetMap<Class<? extends AnalysisConfigurationBase>, Class<? extends AnalysisConfigurationBase>>)requiredClasses);
        }
        return this.topologicalSortConfigs((SetMap<Class<? extends AnalysisConfigurationBase>, Class<? extends AnalysisConfigurationBase>>)requiredClasses);
    }

    private List<AnalysisConfigurationBase> topologicalSortConfigs(SetMap<Class<? extends AnalysisConfigurationBase>, Class<? extends AnalysisConfigurationBase>> requiredClasses) {
        ArrayList<AnalysisConfigurationBase> result = new ArrayList<AnalysisConfigurationBase>();
        while (!requiredClasses.getKeys().isEmpty()) {
            ArrayList found = new ArrayList();
            for (Class clazz : requiredClasses.getKeys()) {
                if (!Objects.requireNonNull((Set)requiredClasses.getCollection((Object)clazz)).isEmpty()) continue;
                found.add(clazz);
            }
            if (found.isEmpty()) {
                throw new AssertionError((Object)("Configurations are not top-sortable! Requirement map is: " + String.valueOf(requiredClasses)));
            }
            found.sort(STABLE_CONFIGURATION_CLASS_COMPARATOR);
            for (Class clazz : found) {
                result.add(this.allConfigurations.get(clazz));
                requiredClasses.removeCollection((Object)clazz);
            }
            for (Class clazz : requiredClasses.getKeys()) {
                CollectionUtils.removeAll((Set)Objects.requireNonNull((Set)requiredClasses.getCollection((Object)clazz)), found);
            }
        }
        return result;
    }

    private static void insertConfigurationToRequired(AnalysisConfigurationBase configuration, SetMap<Class<? extends AnalysisConfigurationBase>, Class<? extends AnalysisConfigurationBase>> requiredClasses) {
        requiredClasses.addAll(configuration.getClass(), (Collection)CollectionUtils.emptyList());
        for (Class<? extends AnalysisConfigurationBase> required : configuration.getRequiredConfigurations()) {
            requiredClasses.add(configuration.getClass(), required);
        }
    }

    public void setConfigurationTemplate(CodeScopeName codeScopeName, ConfigurationTemplate template) {
        this.configurationTemplatePerCodeScope.setValue(codeScopeName, template);
    }

    public ConfigurationTemplate getConfigurationTemplate(CodeScopeName codeScopeName) {
        return this.configurationTemplatePerCodeScope.getValue(codeScopeName);
    }

    public Map<Class<? extends AnalysisConfigurationBase>, AnalysisConfigurationBase> getAllConfigurations() {
        return this.allConfigurations;
    }

    public @Nullable AnalysisGroupDescriptor getAnalysisGroup(String name, CodeScopeName codeScopeName) {
        return this.getConfigurationTemplate(codeScopeName).getAnalysisGroup(name);
    }

    public @Nullable ConfigOptionDescriptorBase getQualityIndicatorOption(String name, CodeScopeName codeScopeName) {
        return this.getConfigurationTemplate(codeScopeName).getQualityIndicatorOption(name);
    }

    public @Nullable ConfigOptionDescriptorBase getGlobalOption(String name, CodeScopeName codeScopeName) {
        return this.getConfigurationTemplate(codeScopeName).getGlobalOption(name);
    }

    public CodeScopeAware<ConfigurationTemplate> getConfigurationTemplatePerCodeScope() {
        return this.configurationTemplatePerCodeScope;
    }

    public Collection<ConfigurationTemplate> getConfigurationTemplates() {
        return this.configurationTemplatePerCodeScope.getValues();
    }
}

