/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.IndexBasedAnalysisConstants;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.ConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.wia.WiaUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class QualityIndicatorTemplate
extends ConfigurationBase {
    private static final String FINDINGS_COUNT = "Number of Findings";
    private static final String FINDINGS_DENSITY = "Findings Density";
    private static final String FINDINGS_DENSITY_YELLOW = "Findings Density (Yellow)";
    private static final String FINDINGS_DENSITY_RED = "Findings Density (Red)";
    private static final String SPEC_ITEM_FINDINGS_DENSITY = "Spec Item Findings Density";
    private static final String SPEC_ITEM_FINDINGS_DENSITY_YELLOW = "Spec Item Findings Density (Yellow)";
    private static final String SPEC_ITEM_FINDINGS_DENSITY_RED = "Spec Item Findings Density (Red)";
    @JsonIgnore
    @ConfigExposed(name="Number of Findings", description="Enables metric for the number of findings for this quality indicator.")
    public boolean qualityIndicatorFindingsCountMetric = false;
    @JsonIgnore
    @ConfigExposed(name="Findings Density", description="Enables metric for the findings density for this quality indicator.")
    public boolean qualityIndicatorFindingsDensityMetric = false;
    @JsonIgnore
    @ConfigExposed(name="Number of Findings (Red)", description="Enables metric for the number of red findings for this quality indicator.")
    public boolean qualityIndicatorFindingsCountRedMetric = false;
    @JsonIgnore
    @ConfigExposed(name="Findings Density (Red)", description="Enables metric for the red findings density for this quality indicator.")
    public boolean qualityIndicatorFindingsDensityRedMetric = false;
    @JsonIgnore
    @ConfigExposed(name="Number of Findings (Yellow)", description="Enables metric for the number of yellow findings for this quality indicator.")
    public boolean qualityIndicatorFindingsCountYellowMetric = false;
    @JsonIgnore
    @ConfigExposed(name="Findings Density (Yellow)", description="Enables metric for the yellow findings density for this quality indicator.")
    public boolean qualityIndicatorFindingsDensityYellowMetric = false;
    @JsonIgnore
    @ConfigExposed(name="Spec Item Findings Density", description="Enables metric for the spec item findings density for this quality indicator.")
    public boolean qualityIndicatorSpecItemFindingsDensityMetric = false;
    @JsonIgnore
    @ConfigExposed(name="Spec Item Findings Density (Red)", description="Enables metric for the red spec item findings density for this quality indicator.")
    public boolean qualityIndicatorSpecItemFindingsDensityRedMetric = false;
    @JsonIgnore
    @ConfigExposed(name="Spec Item Findings Density (Yellow)", description="Enables metric for the yellow spec item findings density for this quality indicator.")
    public boolean qualityIndicatorSpecItemFindingsDensityYellowMetric = false;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="groupNames")
    private final List<String> groupNames = new ArrayList<String>();

    public QualityIndicatorTemplate(String name, Set<ELanguage> languages, AnalysisGroupDescriptor ... groups) {
        this.name = name;
        for (AnalysisGroupDescriptor group : groups) {
            this.addGroup(group);
        }
        this.autoExpose();
        if (!IndexBasedAnalysisConstants.containsFindingsDensityLanguage(languages)) {
            this.hideOption(FINDINGS_DENSITY);
            this.hideOption(FINDINGS_DENSITY_YELLOW);
            this.hideOption(FINDINGS_DENSITY_RED);
        }
        if (!WiaUtils.containsWiaEnabledLanguage(languages)) {
            this.hideOption(SPEC_ITEM_FINDINGS_DENSITY);
            this.hideOption(SPEC_ITEM_FINDINGS_DENSITY_RED);
            this.hideOption(SPEC_ITEM_FINDINGS_DENSITY_YELLOW);
        }
    }

    public String getName() {
        return this.name;
    }

    public void addGroup(AnalysisGroupDescriptor group) {
        CCSMAssert.isTrue((boolean)group.isRegistered(), (String)"May only add groups that have been registered.");
        this.groupNames.add(group.getName());
    }

    public UnmodifiableList<String> getGroupNames() {
        return CollectionUtils.asUnmodifiable(this.groupNames);
    }

    public void removeGroups(Collection<String> groupNamesToRemove) {
        HashSet<String> newGroupNames = new HashSet<String>(this.groupNames);
        newGroupNames.removeAll(groupNamesToRemove);
        this.groupNames.clear();
        this.groupNames.addAll(newGroupNames);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void configureProject(ProjectCreationProxy proxy) {
    }
}

