/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.trigger;

import com.google.common.collect.Lists;
import com.teamscale.core.analysis.trigger.AnalysisStepContext;
import com.teamscale.core.analysis.trigger.IAnalysisStep;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.config.TeamscaleSystemProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.RunnableWithException;

public abstract class MultiThreadedTriggerBase
implements IAnalysisStep {
    AnalysisStepContext context;
    private volatile boolean canceled;
    private final Set<Thread> runningThreads = Collections.synchronizedSet(new IdentityHashSet());

    public final void init(AnalysisStepContext context) {
        this.context = context;
        this.runningThreads.add(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel(boolean interrupt) {
        this.canceled = true;
        if (interrupt) {
            Set<Thread> set = this.runningThreads;
            synchronized (set) {
                this.runningThreads.forEach(Thread::interrupt);
            }
        }
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    protected final AnalysisStepContext getContext() {
        return this.context;
    }

    protected final IParallelTaskExecutor getParallelTaskExecutor() {
        final IParallelTaskExecutor delegate = this.isParallelizationDisabled() ? IParallelTaskExecutor.sameThread() : this.context.getParallelTaskExecutor();
        return new IParallelTaskExecutor(){

            @Override
            public <T, R> R executeInParallelAndCombine(Collection<Callable<T>> tasks, Collector<T, ?, R> collector) throws ExecutionException, InterruptedException {
                if (MultiThreadedTriggerBase.this.isCanceled()) {
                    return (R)CollectionUtils.emptyResult(collector);
                }
                List updatedTasks = CollectionUtils.map(tasks, x$0 -> new CancelableTask(x$0));
                return delegate.executeInParallelAndCombine(updatedTasks, Collectors.filtering(Objects::nonNull, Collectors.mapping(CancelableTask.Result::value, collector)));
            }
        };
    }

    private boolean isParallelizationDisabled() {
        return TeamscaleSystemProperties.DISABLED_TRIGGER_PARALLELIZATION.getValue().map(pattern -> pattern.matcher(this.context.getTriggerName() + ":" + String.valueOf(this.context.getProjectId()))).filter(Matcher::matches).isPresent();
    }

    protected final void executeInParallel(Collection<RunnableWithException<?>> tasks) throws ExecutionException {
        try {
            this.getParallelTaskExecutor().executeInParallel(CollectionUtils.map(tasks, RunnableWithException::asCallable));
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e);
        }
    }

    protected final <T> void executeInParallelBatches(List<T> inputs, ConsumerWithException<List<T>, ?> batchProcessor) throws ExecutionException {
        this.executeInParallelBatches(inputs, batchProcessor, 10);
    }

    protected final <T> void executeInParallelBatches(List<T> inputs, ConsumerWithException<List<T>, ?> batchProcessor, int batchSize) throws ExecutionException {
        if (inputs.isEmpty()) {
            return;
        }
        List batches = Lists.partition(inputs, (int)batchSize);
        this.executeInParallel(CollectionUtils.map((Collection)batches, batch -> () -> batchProcessor.accept(batch)));
    }

    private class CancelableTask<T>
    implements Callable<Result<T>> {
        private final Callable<T> delegate;

        private CancelableTask(Callable<T> task) {
            this.delegate = task;
        }

        @Override
        public @Nullable Result<T> call() throws Exception {
            if (MultiThreadedTriggerBase.this.isCanceled()) {
                return null;
            }
            boolean added = MultiThreadedTriggerBase.this.runningThreads.add(Thread.currentThread());
            try {
                Result<T> result = new Result<T>(this.delegate.call());
                return result;
            }
            finally {
                if (added) {
                    MultiThreadedTriggerBase.this.runningThreads.remove(Thread.currentThread());
                }
            }
        }

        private record Result<T>(T value) {
        }
    }
}

