/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nimbusds.jose.jwk.JWK;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.MultilineOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import java.text.ParseException;
import java.util.List;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="auth.bearer_token", name="Bearer Token", type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.AUTH, orderingHint=3000)
@IndexValueClass(containedInBackup=true)
public class BearerTokenAuthenticationOption
implements IOption {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="publicKey")
    @OptionFieldDescription(name="Public Key", description="Public Key for verifying the integrity of the Bearer Token. JSON object string representation of an ECKey, a RSAKey, or an OctetSequenceKey.")
    @MultilineOption
    public String publicKey;
    @JsonProperty(value="usernameClaim")
    @OptionFieldDescription(name="Claim for username", description="Defines which of the provided claims of the Bearer Token contains the username")
    public String usernameClaim = "username";
    @JsonProperty(value="additionalHeaders")
    @OptionFieldDescription(name="Additional Headers", description="Headers, that might contain the bearer token. If empty, only 'Authorization' is checked.")
    @MultilineOption
    public String additionalHeaders;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        if (StringUtils.isEmpty((String)this.usernameClaim)) {
            return "Provide claim for retrieving the username from the Bearer Token";
        }
        if (StringUtils.isEmpty((String)this.publicKey)) {
            return "Provide a public key";
        }
        try {
            JWK.parse((String)this.publicKey);
        }
        catch (ParseException e) {
            return "Public key cannot be parsed: " + e.getMessage();
        }
        return null;
    }

    public List<String> getAdditionalHeaders() {
        return StringUtils.splitLinesAsList((String)this.additionalHeaders);
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getUsernameClaim() {
        return this.usernameClaim;
    }
}

