/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate;

import com.teamscale.core.analysis.PeriodicMaintenanceJob;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.authenticate.SessionIndex;
import java.time.Duration;
import java.time.Instant;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;

@PeriodicMaintenanceJob(cronExpression="0 * * * *")
public class OutdatedSessionCleanupTrigger
extends MaintenanceTriggerBase {
    @Override
    public void execute() throws StorageException {
        Instant gracePeriod = DateTimeUtils.now().minus(Duration.ofDays(1L));
        this.indexLayer.openGlobalIndex(SessionIndex.class).cleanupSessionsTimedOutBefore(gracePeriod);
    }
}

