/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.base;

import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolSynchronizeTriggerAutoBase;
import com.teamscale.core.authenticate.base.ISynchronizeGroupsStrategy;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class AuthenticationToolSynchronizeTriggerManualBase
extends AuthenticationToolSynchronizeTriggerAutoBase {
    private String serverName;
    private String groupName;

    @Override
    protected void postInitHook() {
        if (this.jobDescriptor.getParameter() == null) {
            throw new IllegalStateException("Expected a job parameter!");
        }
        String[] serverAndGroupName = this.jobDescriptor.getParameter().split(":");
        CCSMAssert.isTrue((serverAndGroupName.length == 2 ? 1 : 0) != 0, (String)("Expected exactly server name and group name separated by ':', but was " + this.jobDescriptor.getParameter()));
        this.serverName = serverAndGroupName[0];
        this.groupName = serverAndGroupName[1];
    }

    @Override
    protected String getServerName() {
        return this.serverName;
    }

    @Override
    protected void synchronize() throws StorageException, AuthenticationToolException {
        if (this.groupName.equals("#ALL_GROUPS#")) {
            this.synchronizeAllGroupsAndUsers();
        } else {
            this.synchronizeSingleGroup();
        }
    }

    private void synchronizeSingleGroup() throws StorageException, AuthenticationToolException {
        ISynchronizeGroupsStrategy strategy = this.getToolProvider().createSynchronizeGroupsStrategy(this.getServerName());
        UserGroupIndex groupIndex = this.indexLayer.openGlobalIndex(UserGroupIndex.class);
        UserGroup group = groupIndex.getUserGroup(this.groupName);
        if (group == null) {
            throw new AuthenticationEntityNotFoundException("Group " + this.groupName + " not found!");
        }
        strategy.synchronizeSingleGroupNow(group.getName());
    }
}

