/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.ldap;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.ImportGroupsStrategyBase;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.ldap.LDAPServerDescription;
import com.teamscale.core.authenticate.ldap.LDAPUtils;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.unboundid.ldap.sdk.LDAPException;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.function.FunctionWithException;

class LDAPImportGroupsStrategy
extends ImportGroupsStrategyBase<LDAPServerDescription> {
    private final ServerOptionIndex optionIndex;

    public LDAPImportGroupsStrategy(NamedServer<LDAPServerDescription> server, UserGroupIndex groupIndex, UserIndex userIndex, ServerOptionIndex optionIndex, IMessageBroker messageBroker, FunctionWithException<EAuthenticationTool, IAuthenticationToolProvider, StorageException> toolProviderFactory) {
        super(server, groupIndex, userIndex, messageBroker, toolProviderFactory);
        this.optionIndex = optionIndex;
    }

    @Override
    protected UserGroup findGroup(String groupName) throws AuthenticationToolException {
        return LDAPUtils.findGroup(groupName, (LDAPServerDescription)this.getServer().serverDescription(), this.getServer().name());
    }

    @Override
    protected ListMap<NamedServer<LDAPServerDescription>, String> getUsersInGroup(UserGroup group) throws StorageException, AuthenticationToolException {
        try {
            return LDAPUtils.getUsersInGroup(this.getServer().name(), (LDAPServerDescription)this.getServer().serverDescription(), group, this.optionIndex);
        }
        catch (LDAPException e) {
            throw new AuthenticationToolException("Group import failed", e);
        }
    }
}

