/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class MigrationUtils {
    public static String renameElement(String oldElementName, String newElementName, String xml) {
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = Pattern.compile("(</?)" + Pattern.quote(oldElementName) + "(\\s.*?>|>)").matcher(xml);
        while (matcher.find()) {
            matcher.appendReplacement(buffer, matcher.group(1) + newElementName + matcher.group(2));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String renameClass(String oldClassName, String newClassName, String xml) {
        String regex = "class=\"" + Pattern.quote(oldClassName) + "\"";
        String replacement = "class=\"" + Matcher.quoteReplacement(newClassName) + "\"";
        return xml.replaceAll(regex, replacement);
    }

    private MigrationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

