/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import java.lang.reflect.Field;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;

public abstract class AnalysisStepMemberAccessorBase {
    private final List<Field> fieldStack;

    protected AnalysisStepMemberAccessorBase(List<Field> fieldStack) {
        this.fieldStack = fieldStack;
        for (Field field : fieldStack) {
            field.setAccessible(true);
        }
    }

    protected Object getInstanceFromFieldStack(AnalysisStepBase instance) throws IllegalAccessException {
        Object currentInstance = instance;
        for (Field field : this.fieldStack) {
            Object newInstance = field.get(currentInstance);
            CCSMAssert.isNotNull((Object)newInstance, () -> "Analysis Step Field '" + field.getName() + "' of class '" + String.valueOf(field.getDeclaringClass()) + "' was null. Did you forget to initialize it?");
            currentInstance = newInstance;
        }
        return currentInstance;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getToStringPrefix());
        builder.append(" [");
        for (Field field : this.fieldStack) {
            builder.append(field.getName()).append(" -> ");
        }
        builder.append(this.getMemberName()).append("]");
        return builder.toString();
    }

    protected abstract String getToStringPrefix();

    protected abstract String getMemberName();
}

