/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepFieldAccessorBase;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.conqat.lib.commons.reflect.TypeConversionException;

public class AnalysisStepParameter
extends AnalysisStepFieldAccessorBase {
    private final StepParameter parameter;
    private final String namePrefix;

    AnalysisStepParameter(Field field, List<Field> fieldStack, String namePrefix, StepParameter parameter) throws TriggerCompilationException {
        super(field, fieldStack);
        this.namePrefix = namePrefix;
        this.parameter = parameter;
    }

    public String getName() {
        return this.namePrefix + this.parameter.value();
    }

    @Override
    protected String getToStringPrefix() {
        return "Step parameter: " + this.getName();
    }

    public void setValue(AnalysisStepBase instance, Object value) {
        this.set(instance, value);
    }

    public boolean isOptional() {
        return this.parameter.optional();
    }

    public Object parseValue(TriggerDescription.Parameter<?> value) throws TriggerCompilationException {
        Type targetType = this.getField().getGenericType();
        try {
            return value.as(targetType);
        }
        catch (TypeConversionException e) {
            throw new TriggerCompilationException("Could not convert '" + String.valueOf(value) + "' to type " + String.valueOf(targetType) + " in " + String.valueOf(this), e);
        }
    }

    static Class<?> getNthGenericTypeArgument(Field field, int index) throws TriggerCompilationException {
        Type typeArgument = AnalysisStepParameter.getTypeOfNthGenericTypeArgument(field, index);
        if (!(typeArgument instanceof Class)) {
            throw new TriggerCompilationException("Expecting type argument " + index + " of field " + String.valueOf(field) + " to be of type Class, but was " + String.valueOf(typeArgument.getClass()));
        }
        return (Class)typeArgument;
    }

    private static Type getTypeOfNthGenericTypeArgument(Field field, int index) throws TriggerCompilationException {
        if (!(field.getGenericType() instanceof ParameterizedType)) {
            throw new TriggerCompilationException("Expecting type of field " + String.valueOf(field) + " to be of ParameterizedType, but was " + String.valueOf(field.getGenericType().getClass()));
        }
        return ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[index];
    }
}

