/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis.step;

import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepMemberAccessorBase;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class AnalysisStepPostInjectionMethod
extends AnalysisStepMemberAccessorBase {
    private final Method method;

    AnalysisStepPostInjectionMethod(Method method, List<Field> fieldStack) throws TriggerCompilationException {
        super(fieldStack);
        this.method = method;
        method.setAccessible(true);
        if (method.getParameterTypes().length != 0) {
            throw new TriggerCompilationException("AnalysisStep post parameter injection methods must not have parameters! Method: " + method.getDeclaringClass().getName() + "#" + method.getName());
        }
    }

    public void invoke(AnalysisStepBase analysisStepInstance) {
        try {
            Object instance = this.getInstanceFromFieldStack(analysisStepInstance);
            this.method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Illegal access: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("Illegal target: " + e.getMessage(), e);
        }
    }

    @Override
    protected String getToStringPrefix() {
        return "Post injection method: ";
    }

    @Override
    protected String getMemberName() {
        return this.method.getName();
    }
}

