/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.impl.worker.MountedStorageSystemLockSupport;
import com.teamscale.core.runtime.impl.worker.NonLockingLockSupport;
import java.util.Set;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

public interface ICrossProjectLockSupport {
    public void collectNeededLocks(SchemaEntry var1, IStore var2);

    public void collectNeededLocks(SchemaEntry var1, IStorageIndex var2);

    public void lock();

    public void unlock();

    public static ICrossProjectLockSupport createForProject(InternalProjectId projectId, ProjectIndex projectIndex, ILockProvider lockProvider) throws StorageException {
        Set<InternalProjectId> crossProjectReferenceCluster = projectIndex.getRelatedInternalProjectIds(projectId);
        if (crossProjectReferenceCluster.size() > 1) {
            return new MountedStorageSystemLockSupport(lockProvider);
        }
        return new NonLockingLockSupport();
    }
}

