/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.logging;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.LogEventCollector;
import org.conqat.engine.core.logging.TeamscaleLoggingConfigurationFactory;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Plugin(name="TeamscaleCustomLog", category="Core", elementType="appender", printObject=true)
public class TeamscaleCustomLogAppender
extends AbstractAppender {
    static final String NAME = "TeamscaleCustomLog";
    private static final String APPENDER_REF = "TEAMSCALE_INTERNAL_CUSTOM";
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static LogEventCollector logEventCollector = new LogEventCollector();

    private TeamscaleCustomLogAppender(String name, Filter filter, Layout<?> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
    }

    @PluginFactory
    public static TeamscaleCustomLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filters") Filter filter, @PluginElement(value="Layout") Layout<?> layout, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions) {
        Objects.requireNonNull(name, "name");
        return new TeamscaleCustomLogAppender(name, filter, layout, ignoreExceptions);
    }

    public static UnmodifiableList<LogEvent> getAndClearEvents() {
        LogEventCollector tmp;
        LOCK.writeLock().lock();
        try {
            tmp = logEventCollector;
            logEventCollector = new LogEventCollector();
        }
        finally {
            LOCK.writeLock().unlock();
        }
        return tmp.getLogEvents();
    }

    public void append(LogEvent event) {
        event.getThreadName();
        LOCK.readLock().lock();
        try {
            logEventCollector.addEvent(event);
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public static void updateLog4j(Map<String, ELogLevel> loggerConfiguration) {
        Configurator.reconfigure((Configuration)TeamscaleCustomLogAppender.buildConfiguration(loggerConfiguration));
    }

    private static Configuration buildConfiguration(Map<String, ELogLevel> loggerConfiguration) {
        AbstractConfiguration defaultConfiguration = TeamscaleLoggingConfigurationFactory.getConfiguration();
        if (loggerConfiguration.isEmpty()) {
            return defaultConfiguration;
        }
        AbstractConfiguration config = TeamscaleCustomLogAppender.buildCustomConfiguration(loggerConfiguration);
        List<AbstractConfiguration> configuration = List.of(defaultConfiguration, config);
        return TeamscaleCustomLogAppender.buildComposite(configuration);
    }

    private static Configuration buildComposite(List<AbstractConfiguration> configurations) {
        CompositeConfiguration result = new CompositeConfiguration(configurations);
        for (AbstractConfiguration configuration : configurations) {
            result.getProperties().putAll(configuration.getProperties());
        }
        return result;
    }

    private static AbstractConfiguration buildCustomConfiguration(Map<String, ELogLevel> loggerConfiguration) {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.add(builder.newAppender(APPENDER_REF, NAME));
        for (Map.Entry<String, ELogLevel> configEntry : loggerConfiguration.entrySet()) {
            String logger = configEntry.getKey();
            ELogLevel level = configEntry.getValue();
            builder.add((LoggerComponentBuilder)builder.newLogger(logger, level.getLog4JLevel()).add((AppenderRefComponentBuilder)builder.newAppenderRef(APPENDER_REF).addAttribute("level", level.getLog4JLevel())));
        }
        return (AbstractConfiguration)builder.build(false);
    }
}

