/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.metrics.ComplexityVisitor;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S1311")
public class ClassComplexityCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S1311";
    private static final String MESSAGE = "The Cyclomatic Complexity of this class \"%s\" is %s which is greater than %s authorized, split this class.";
    private static final String MESSAGE_ANONYMOUS_CLASS = "The Cyclomatic Complexity of this anonymous class is %s which is greater than %s authorized, split this class.";
    public static final int DEFAULT = 200;
    @RuleProperty(key="max", defaultValue="200")
    int max = 200;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS_DECLARATION, Tree.Kind.ANONYMOUS_CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        List<Tree> complexityTrees = ComplexityVisitor.complexityTrees(tree);
        int complexity = complexityTrees.size();
        if (complexity > this.max) {
            int cost = complexity - this.max;
            PreciseIssue issue = this.context().newIssue(this, ((ClassTree)tree).classToken(), this.message(tree, complexity)).cost(cost);
            complexityTrees.forEach(complexityTree -> issue.secondary((Tree)complexityTree, "+1"));
        }
    }

    private String message(Tree tree, int complexity) {
        if (tree.is(Tree.Kind.CLASS_DECLARATION)) {
            String className = ((ClassDeclarationTree)tree).name().text();
            return String.format(MESSAGE, className, complexity, this.max);
        }
        return String.format(MESSAGE_ANONYMOUS_CLASS, complexity, this.max);
    }
}

