/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.utils.LiteralUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S4426")
public class CryptographicKeySizeCheck
extends PHPVisitorCheck {
    public static final String KEY = "S4426";
    private static final int MIN_KEY_LENGTH = 2048;
    private static final String MESSAGE = "Use a key length of at least 2048 bits";

    @Override
    public void visitFunctionCall(FunctionCallTree functionCall) {
        if ("openssl_pkey_new".equals(CheckUtils.lowerCaseFunctionName(functionCall))) {
            CheckUtils.argumentValue(functionCall, "options", 0).flatMap(this::getKeySize).filter(this::lessThanMinKeyLength).ifPresent(keySize -> this.context().newIssue(this, (Tree)keySize, MESSAGE));
        }
        super.visitFunctionCall(functionCall);
    }

    private boolean lessThanMinKeyLength(ExpressionTree keySize) {
        if (keySize.is(Tree.Kind.NUMERIC_LITERAL)) {
            LiteralTree literal = (LiteralTree)keySize;
            long size = LiteralUtils.longLiteralValue(literal.value());
            return size < 2048L;
        }
        if (keySize.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            return CheckUtils.uniqueAssignedValue((VariableIdentifierTree)keySize).map(this::lessThanMinKeyLength).orElse(false);
        }
        return false;
    }

    private Optional<ExpressionTree> getKeySize(ExpressionTree config) {
        if (config.is(Tree.Kind.ARRAY_INITIALIZER_FUNCTION, Tree.Kind.ARRAY_INITIALIZER_BRACKET) && CryptographicKeySizeCheck.isRSA((ArrayInitializerTree)config)) {
            return ((ArrayInitializerTree)config).arrayPairs().stream().filter(pair -> CryptographicKeySizeCheck.hasKey(pair, "private_key_bits")).map(ArrayPairTree::value).findFirst();
        }
        if (config.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            return CheckUtils.uniqueAssignedValue((VariableIdentifierTree)config).flatMap(this::getKeySize);
        }
        return Optional.empty();
    }

    private static boolean hasKey(ArrayPairTree pair, String keyName) {
        return pair.key() != null && pair.key().is(Tree.Kind.REGULAR_STRING_LITERAL) && keyName.equals(CheckUtils.trimQuotes((LiteralTree)pair.key()));
    }

    private static boolean isRSA(ArrayInitializerTree config) {
        return config.arrayPairs().stream().anyMatch(pair -> {
            if (!CryptographicKeySizeCheck.hasKey(pair, "private_key_type")) {
                return false;
            }
            if (pair.value().is(Tree.Kind.NAMESPACE_NAME)) {
                NamespaceNameTree value = (NamespaceNameTree)pair.value();
                return "OPENSSL_KEYTYPE_RSA".equals(value.name().text());
            }
            return false;
        });
    }
}

